function polarmotion,utc,latitude
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
Longitude=GeoParms.Longitude
Latitude=GeoParms.Latitude
Altitude=GeoParms.Altitude
EarthRadius=GeoParms.EarthRadius
J2=GeoParms.J2
;
; Apply polarmotion corrections to Longitude and Latitude
; Convert to earth-fixed, rotating, rectangular, right-handed geocentric system
C=1/sqrt((cos(Latitude/RAD))^2+(1-J2)^2*(sin(Latitude/RAD))^2)
S=(1-J2)^2*C
n_utc=n_elements(utc)
pos1=dblarr(3,n_utc,/nozero)
pos1[0,*]=(EarthRadius*C+Altitude)*cos(Latitude/RAD)*cos(Longitude/RAD)
pos1[1,*]=(EarthRadius*C+Altitude)*cos(Latitude/RAD)*sin(Longitude/RAD)
pos1[2,*]=(EarthRadius*S+Altitude)*sin(Latitude/RAD)
pos2=pos1
;
utc_days=utc/86400
pole_x=poly(utc_days,GeoParms.pole_x_coeffs)
pole_y=poly(utc_days,GeoParms.pole_y_coeffs)
status=linknload(!external_lib,'polarmotion',n_utc,pole_x,pole_y,pos1,pos2)
;
; Convert back to longitude, latitude system
Longitude=atan(pos2[1,*],pos2[0,*])*RAD
Latitude=asin(pos2[2,*]/(EarthRadius*S+Altitude))*RAD
;
if n_utc eq 1 then begin
	Longitude=Longitude[0]
	Latitude=Latitude[0]
endif
;
return,longitude
;
end
