function pollux_models_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotPolluxData,files,regions,r_label,t_grid,g_grid,t_eff,log_g
common PlotPolluxObs,fits_file,wave,spec,error,qual,header,h_ext1,h_ext2
common LocalPolluxModelsEvent,model,flux,lamn
;
; Restore Pollux spectrum (lambda_aa -> lamn,flux)
if size(event,/type) eq 8 then begin
	widget_control,event.id,get_uvalue=models
	model=models[event.index]
	restore,!atmospheres_dir+'pollux/'+model; Restores lambda_aa and flux
; 	Interpolate onto finer grid
	l=findgen(50001)*0.1+19500
	f=interpol(flux,lambda_aa,l)
	lamn=l/10
	flux=f
endif
;
; Normalize spectrum
r=polyfit(lamn,flux,3,yfit)
flux=flux/yfit
;
; Find best-fit Gaussian smoothing kernel and wavelength shift
j=0	; shift [pixels]
i=0	; Gaussian smoothing width [pixels]
if wave[0] ne 0 then begin
	l_min=2160.
	l_max=2170.
	l_min=2445.
	l_max=2449.
	wave_brg=wave[where(wave ge l_min and wave le l_max)]
	spec_brg=spec[where(wave ge l_min and wave le l_max)]
	lamn_brg=lamn[where(lamn ge l_min and lamn le l_max)]
	flux_brg=flux[where(lamn ge l_min and lamn le l_max)]
;	Loop over Gaussian smoothing width (in units of Pollux pixels)
	imin=4
	imax=20
;	Loop of wavelength shift (in units of Pollux pixels)
	jmin=20
	jmax=120
;	Compute fit quality for each combination
	chisq=fltarr(jmax-jmin+1,imax-imin+1)
	for i=imin,imax do begin
	flux_c=gauss_smooth(flux_brg,i,/edge_truncate)
	for j=jmin,jmax do chisq[j-jmin,i-imin]= $
		total((spec_brg-interpol(shift(flux_c,j),lamn_brg,wave_brg))^2)
	endfor
	print,model+', minimum chi^2 =',min(chisq)
	r=whereindex(where(chisq eq min(chisq)),chisq)
	j=r[0]+jmin
	i=r[1]
endif
;
; Plot Pollux spectrum...
if n_elements(wave) le 1 then begin
	plot,lamn,flux,xtitle=greek('lambda')+' [nm]', $
		xstyle=1,xticks=12,xminor=5,charsize=1.5
; ...or observed spectrum and selected Pollux spectrum (shifted, convolved)
endif else begin
	flux_w=interpol(shift(gauss_smooth(flux,i,/edge_truncate),j),lamn,wave)
	plot,wave,flux_w, $
		xtitle=greek('lambda')+' [nm]', $
		xstyle=1,xticks=12,xminor=5,charsize=1.5
	oplot,wave,spec,psym=0,color=tci(3)
;	Write the line-corrected spectrum, adding "_n" to the name
	fitsfile=file_basename(fits_file,'.fits')+'_n.fits'
	writefits,fitsfile,spec/flux_w,header
	writefits,fitsfile,error,h_ext1,/append
	writefits,fitsfile,qual,h_ext2,/append
endelse
;
end
