function polyfit,x_in,y_in,degree,yft
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; A better polynomial fit routine than IDL's own poly_fit.
; Arrays x and y are shifted to improve numerical stability.
;
if degree gt 6 then begin
	print,'***Error(POLYFIT): polynomial order too high!'
	return,0
endif
num=n_elements(x_in)
if num eq 0 then begin
	print,'***Error(POLYFIT): x undefined!'
	return,0
endif
if num ne n_elements(y_in) then begin
	print,'***Error(POLYFIT): number of elements in x and y not equal!'
	return,0
endif
;
; Make sure to remove leading empty dimensions and convert to double
x=double(reform(x_in,num))
y=double(reform(y_in,num))
;
x_mid=(min(x)+max(x))/2
x_scl=2/(max(x)-min(x))
terms=['L_0','L_1','L_2','L_3','L_4','L_5','L_6']
terms=['1','x','x^2','x^3','x^4','x^5','x^6']
m=dblarr(num,degree+1)
for i=0,degree do m[*,i]=evalfunction(terms[i],x,x_mid,x_scl)
tm=transpose(m)
n=tm#m
r=tm#y
s=invert(n)#r
r=[s,[x_mid,x_scl]]
;
yft=polynom(x,r)
return,r
;
end
