function powerpatch,t,s,t_new,limit=limit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; t must be in ms, type long.
;
if not keyword_set(limit) then limit=100
;
n=n_elements(t)
dt=t[1:n-1]-t[0:n-2]
t_int=long(median(dt))
print,'Sampling interval seems to be ',t_int,' ms'
index=where(dt ne t_int,icount)
print,'Found ',icount,' gaps in time series'
if icount gt 0 then begin
	dtg=t[index+1]-t[index]
	jndex=where(dtg/t_int gt limit,jcount)
	if jcount gt 0 then begin
		print,'Gap(s) too large [s]: ', $
			(t[index[jndex+1]]-t[index[jndex]])/1000.0
		kndex=[0-1,index[jndex],n-1]
	endif else kndex=[0-1,n-1]
	nk=n_elements(kndex)
	n1=kndex[0:nk-2]
	n2=kndex[1:nk-1]
	dts=t[n2]-t[n1+1]
	print,'Fixable section(s) [s]: ',dts/1000.0
	i=where(dts eq max(dts)) & i=i[0]
	n1=n1[i]+1
	n2=n2[i]
endif else begin
	n1=0
	n2=n-1
endelse
t_new=t[n1]+(lindgen((t[n2]-t[n1])/t_int+1)*t_int)
return,interpol(s,t,t_new)
;
if count eq 0 then begin
	t_new=t
endif else begin
	n_new=n
	for i=0,count-1 do begin
		dt=t[index[i]+1]-t[index[i]]
		num=dt/t_int
		if num lt limit then n_new=n_new+num-1
	endfor
	t_new=lonarr(n_new,/nozero)
	t_new[0:index[0]]=t[0:index[0]]
	k=index[0]+1
endelse
for i=0,count-1 do begin
	dt=t[index[i]+1]-t[index[i]]
	num=dt/t_int
	if num lt limit then begin
		t_new[k:k+num-2]=(lindgen(num-1)+1)*t_int+t[index[i]]
		k=k+num-1
	endif
	if i lt count-1 then m=index[i+1] else m=n-1
	t_new[k:k+m-index[i]-1]=t[index[i]+1:m]
	k=k+m-index[i]
;
end
;
n=n_elements(t_new)
dt=t_new[1:n-1]-t_new[0:n-2]
index=where(dt ne t_int,count)
print,'Gaps remaining after patching: ',count,'.'
if count gt 0 then begin
	index=[-1,index,n-1]
	l=index[1:count+1]-index[0:count]
	j=where(l eq max(l))
	t_new=t_new[index[j[0]]+1:index[j[0]+1]]
endif
;
return,interpol(s,t,t_new)
;
end
