function powerspectrum,series,sampling_int,f,p,f_avg,p_avg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Input series must have power-of-two number of elements.
; Compute power spectrum and return square-root of total
; power, which is equal to the standard deviation of the
; series.
;
; Compute frequencies and the Fourier transform
;
n=n_elements(series)
m=lindgen(n)
f=m/(n*sampling_int)
p=fft(series,-1)
;
; Frequencies f above the Nyquist frequency are not physically meaningful
; The frequency interval is 1/(n*sampling_int), Nyquist frequency is
; n/2*frequency_int=1/(2*sampling_int)=1/2 * sampling_rate. In other words,
; the power spectrum is only representative of the series up to the Nyquist
; frequency.
;
n=n/2
;
; We want units in power/Hz. Since there are n frequencies, and the sum
; over n of the power spectrum is normalized, but the frequency range is
; from 0 to (1/sampling_int)/2, the ratio of the two must be multiplied
; with the power.
;
norm_factor=n/((1/sampling_int)/2)
p=norm_factor*2*abs(p[0:n])^2
f=f[0:n]
;
; Avoid zero power situations...
r=machar() & tiny=r.xmin
p=p>tiny
;
; Average power in constant logarithmic intervals
num=long(alog10(n)*400)
int=alog10(double(n))/(num-1)
index=nint(10^(dindgen(num)*int))
jndex=uniq(index)
num=n_elements(jndex)-1
f_avg=dblarr(num)
p_avg=f_avg
for i=0,n_elements(jndex)-2 do begin
	f_avg[i]=10^avg(alog10(f[index[jndex[i]]:index[jndex[i+1]]-1]))
	p_avg[i]=10^avg(alog10(p[index[jndex[i]]:index[jndex[i+1]]-1]))
endfor
;
; The total power (sum over all elements of p, without norm_factor)
; is equal to the variance of the series. The factor 2 (see above)
; adjusts for the fact that our sum here is only over one side of
; the FFT.
;
return,sqrt(total(p/norm_factor))
;
;
end
