function ppwv,t,h
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a temperature t[C] and relative humidity h[%], return the
; partial water vapor pressure [mb].
; Note that hPa=mb!
;
; From a fit to the saturation water vapor pressure=alog(f)(t[C])
; http://www.engineeringtoolbox.com/relative-humidity-air-d_687.html
coeffs=[1.8092268,0.072935087,-0.00030139676,8.5339579e-07]
swvp=exp(poly(t,coeffs))
;
return,(h/100.)*swvp
;
end
