function precess,theta,jy,ra,dec,direction
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Precess J2000 position angles (theta) to current Julian Year epoch (jy) for
; direction=1, from current to J2000 for direction=-1.
; (see: Heintz, "Double stars", p. 33).
; Input theta is in radians, dec in degrees, ra in hours; output is in radians.
;
return,theta	; needs equinox instead of epoch
;
RAD=180/!pi
;
c=0.00557*sin(ra*15/RAD)/cos(dec/RAD)*(jy-2000.0)
return,theta+float(direction)*c/RAD
;
; Proper motion correction:
; c=-mu*sin(dec)*(jy-2000) with mu=proper motion in RA expressed in arcseconds
; (The binary stars, Robert Aitken, p. 73)
;
end
