pro print_scanforms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Format the scan and bg scan listings and submit to printer.
;
common StarBase,startable,notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([1,2,3]) ne 0 then return
;
list_stars,stars
;
filename1='oyster1.txt'
openw,unit,filename1,/get_lun
;
max_per_line=11
;
printf,unit,'Star    | Diam.|  Mag.|Cal| Scans           '
for i=0,n_elements(stars)-1 do begin
	printf,unit,'--------|------|------|---|---------------------------------------
	j=where(startable.starid eq stars[i])
	index=where(ScanTable.starid eq stars[i] and ScanTable.code eq 1,count)
	if count gt max_per_line then n=max_per_line else n=count
	printf,unit,startable[j].starid,' | ',startable[j].diameter,' | ', $
		startable[j].mv,' | ',startable[j].bflag,' | ', $
		ScanTable[index[0:n-1]].iscan, $
		format='(a,a,f4.1,a,f4.1,a,a,a,20(i3,1x))'
	count=count-n
	line=0
	while count gt 0 do begin
	  line=line+1
	  if count gt max_per_line then n=max_per_line else n=count
	  printf,unit,'                          | ', $
	    ScanTable[index[line*max_per_line:line*max_per_line+n-1]].iscan, $
	    format='(a,20(i3,1x))'
	  count=count-n
	endwhile
endfor
printf,unit,'--------|------|------|---|----------------------------------------
for i=1,3 do printf,unit,''
printf,unit,'Notes:'
;
free_lun,unit
;
filename2='oyster2.txt'
openw,unit,filename2,/get_lun
;
max_per_line=9
;
printf,unit,'Star    | BG Scans           '
for i=0,n_elements(stars)-1 do begin
	printf,unit,'--------|---------------------------------------------------------
	j=where(startable.starid eq stars[i])
	index=where(ScanTable.starid eq stars[i],count)
	printf,unit,startable[j].starid,' | ',format='(a,a,$)'
	for k=0,count-1 do begin
		if k mod max_per_line eq 0 and k ne 0 then begin
			printf,unit,''
			printf,unit,'        | ',format='(a,$)'
		endif
		jndex=where(BGTable.scanid eq ScanTable[index[k]].scanid,n)
		for l=0,n-1 do printf,unit,BGTable[jndex[l]].iscan,' ',format='(i3,a,$)'
		if n eq 0 then space='    ' else space=''
		printf,unit,space,'| ',format='(a,a,$)'
	endfor
	printf,unit,''
endfor
printf,unit,'--------|----------------------------------------------------------
;
free_lun,unit
;
psfile='oyster.ps'
;
if strpos(strupcase(getenv('HOST')),'OCTANS') ne -1 then begin
	spawn,'nenscript -p'+psfile+' -fCourier9 -b'+Date+' '+filename1+' '+filename2
	spawn,'lpr '+psfile
endif else if strpos(strupcase(getenv('HOST')),'FERMION') ne -1 then begin
	spawn,'mpage -o -1 -I5 -X'+Date+' '+filename1+' '+filename2+' > '+psfile
	spawn,'lpr '+psfile
endif else if strpos(strupcase(getenv('HOST')),'GEMINI') ne -1 then begin
	spawn,'mpage -o -1 -I5 -X'+Date+' '+filename1+' '+filename2+' > '+psfile
	spawn,'lpr '+psfile
endif else begin
	spawn,'lpr '+filename1
	spawn,'lpr '+filename2
endelse
spawn,'rm -f '+psfile
spawn,'rm -f '+filename1+' '+filename2
print,'Forms submitted to printer.'
;
end
