pro print_specforms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if checkdata([5,8]) ne 0 then return
;
filename='form.txt'
psfile='form.ps'
;
FOR i=1,GenConfig.NumOutBeam DO BEGIN
openw,unit,filename,/get_lun
printf,unit, $
'Ch   BG    Flg  SM   Sl   RMS   Spectrometer '+string(i,format='(i1)')
for j=1,GenConfig.NumSpecChan[i-1] do begin
printf,unit, $
'---||----|----|----|----|----|----------------------------------------||'
printf,unit,string(j,format='(i2.2)')+ $
  ' ||    |    |    |    |    |                                        ||'
endfor
printf,unit, $
'---||----|----|----|----|----|----------------------------------------||'
free_lun,unit
;
if strpos(strupcase(getenv('HOST')),'FORNAX') ne -1 then begin
	spawn,'mp -pagelength 70 -linelength 120 -subject '+Date+' ' $
		+filename+' > '+psfile
	spawn,'lp -onb -drpnpoipost '+psfile
endif else if strpos(strupcase(getenv('HOST')),'OCTANS') ne -1 then begin
	spawn,'nenscript -p'+psfile+' -fCourier9 -b'+Date+' '+filename
	spawn,'lpr '+psfile
endif else if strpos(strupcase(getenv('HOST')),'FERMION') ne -1 then begin
	spawn,'mpage -o -1 -I5 -X'+Date+' '+filename+' > '+psfile
	spawn,'lpr '+psfile
endif else if strpos(strupcase(getenv('HOST')),'GEMINI') ne -1 then begin
	spawn,'mpage -o -1 -I5 -X'+Date+' '+filename+' > '+psfile
	spawn,'lpr '+psfile
endif else spawn,'lpr '+filename
spawn,'rm -f '+psfile
spawn,'rm -f '+filename
ENDFOR
print,'Forms submitted to printer.'
;
end
