function provis,profile,mu,arg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the visibility of a stellar atmosphere specified with a profile
; as a function of mu=cos(theta), mu=1 at the center (see Wittkowski 2003):
; F_LD(lamda)=Int_[0,1] I_lamda(mu) J0(2pi*r_LD*B/lamda*sqrt(1-mu^2)) mu dmu
; To normalize, divide by Int_[0,1] I_lamda(mu) mu dmu.
; sqrt(1-mu^2)=sin(theta), the projected radius
;
common LocalProvis,r,a
;
f1=(mu*profile)/profile[n_elements(mu)-1]
f2=beselj(arg*sqrt(1-mu^2),0)*f1
;
return,int_tabulated(mu,f2)/int_tabulated(mu,f1)
;
; Obsolete
a=arg
r=poly_fit(mu,f1,3)
return,qromb('provis_f2',0,1,/double)/qromb('provis_f1',0,1,/double)
;
end
