pro psn2tex,component,hjd=hjd,aas=aas
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Version for 73 Leo paper
;
; Prepare LaTeX file from astrometric measurements of a binary.
; Must load astrometry and read model first. Use HJD if hjd=1 instead of JY.
; Prepare in A&A LaTex format (or AAS if aas=1).
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
if n_elements(hjd) eq 0 then hjd=0
if n_elements(aas) eq 0 then aas=0
;
if n_elements(component) eq 0 then begin
	component=''
	read,component,prompt='Please enter component: '
endif
if n_elements(positions) eq 0 then begin
	print,'***Error(PSN2TEX): no astrometry!'
	return
endif
if n_elements(gen_model) eq 0 then begin
	print,'***Error(PSN2TEX): no model!'
	return
endif
index=where(positions.component eq component,count)
if count eq 0 then begin
	print,'***Error(PSN2TEX): no data for this component!'
	return
endif
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
; Compute data
RAD=180/!pi
ds_options_i=ds_options.i
ds_options.i=0
calcmodel
ds_options.i=ds_options_i
x=positions.rho*sin(positions.theta)
y=positions.rho*cos(positions.theta)
xm=positions.rhom*sin(positions.thetam)
ym=positions.rhom*cos(positions.thetam)
oc=sqrt((x-xm)^2+(y-ym)^2)
oca=atan(x-xm,y-ym)*RAD
ocr=positions.rho-positions.rhom
oct=((positions.theta-positions.thetam)*RAD) mod 360
index=where(oct gt 180,count)
if count gt 0 then oct[index]=oct[index]-360
;
; Open output file
file_out=gen_model.starid+'_psn.tex'
openw,unit,file_out,/get_lun
;
IF aas THEN BEGIN
;
; AJ and ApJ
printf,unit,'\documentclass{/home/chummel/latex/aastex/aastex61}'
printf,unit,'\begin{document}'
printf,unit,'\begin{deluxetable}{cccccrrr}'
printf,unit,'\tabletypesize{\scriptsize}'
printf,unit,'\tablecaption{Observation and result log for ' $
	    +gen_model.starid+'}\label{table1}'
printf,unit,'\tablehead{'
if hjd then printf,unit,'\colhead{HJD $-$}&' $
       else printf,unit,'\colhead{Julian Year}&'
printf,unit,'\colhead{$\theta$}&'
printf,unit,'\colhead{$\rho$}&'
printf,unit,'\colhead{$\sigma_{\rm maj}$}&'
printf,unit,'\colhead{$\sigma_{\rm min}$}&'
printf,unit,'\colhead{$\varphi$}&'
printf,unit,'\colhead{O--C$_\rho$}&'
printf,unit,'\colhead{O--C$_\theta$}'
printf,unit,'\\'
if hjd then printf,unit,'\colhead{$2,400,000$}&' $
       else printf,unit,'\colhead{}&'
printf,unit,'\colhead{(deg)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(deg)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(deg)}'
printf,unit,'\\'
printf,unit,'\colhead{(1)}&'
printf,unit,'\colhead{(2)}&'
printf,unit,'\colhead{(3)}&'
printf,unit,'\colhead{(4)}&'
printf,unit,'\colhead{(5)}&'
printf,unit,'\colhead{(6)}&'
printf,unit,'\colhead{(7)}&'
printf,unit,'\colhead{(8)}'
printf,unit,'}'
printf,unit,'\startdata'
;
ENDIF ELSE BEGIN
;
printf,unit,'\documentclass[twocolumn]{/home/chummel/latex/aa-package/aa}'
printf,unit,'\usepackage{graphicx}'
printf,unit,'\usepackage{txfonts}'
printf,unit,'\usepackage{natbib}'
printf,unit,'\usepackage{upgreek}'
printf,unit,'\usepackage{url}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{NPOI results for '+gen_model.starid+'}'
printf,unit,'\label{npoi_res}'
printf,unit,'\begin{tabular}{ccrrrrrrr}'
printf,unit,'\hline'
printf,unit,'\hline'
printf,unit,'Julian year&Number of&$\rho$&$\theta$&$\sigma_{\rm maj}$&$\sigma_{\
printf,unit,'HJD $-$&Number of&$\rho$&$\theta$&$\sigma_{\rm maj}$&$\sigma_{\rm m
printf,unit,'$2,400,000$&visibilities&(mas)&(deg)&(mas)&(mas)&(deg)&(mas)&(deg)\
printf,unit,' (1) & (2) & (3) & (4) & (5) & (6) & (7) & (8) & (9) \\'
printf,unit,'\hline'
;
ENDELSE
;
for i=0,n_elements(positions)-1 do begin
	if positions[i].component eq component then begin
	date=positions[i].date	; Can be off by 1 day if obs. started early!
	date=jd2date(2440000.d0+positions[i].jd $
		+double(system_config('NPOI','MIDNIGHT'))/24)
	parsedate,date,y,m,d
	year=string(y,format='(i4.4)')
	month=months[long(strmid(date,5,2))-1]
	day=strmid(date,8,2)
;
	if hjd then $
	printf,unit, $
		jy2jd(positions[i].jy)-2400000.d0, $
		positions[i].theta*RAD,positions[i].rho, $
		positions[i].emajor,positions[i].eminor,positions[i].pa*RAD, $
		ocr[i],oct[i], $
		format='(f9.3,"&",f7.2,"&",f6.2,"&",f6.2,"&",f6.2,"&",f5.1,"&",f6.2,"&",f6.1,"
	       else $
	printf,unit, $
		positions[i].jy, $
		positions[i].theta*RAD,positions[i].rho, $
		positions[i].emajor,positions[i].eminor,positions[i].pa*RAD, $
		ocr[i],oct[i], $
		format='(f9.3,"&",f7.2,"&",f6.2,"&",f6.2,"&",f6.2,"&",f5.1,"&",f6.2,"&",f6.1,"
	endif
endfor
;
IF aas THEN BEGIN
	printf,unit,'\enddata'
	printf,unit,'\end{deluxetable}'
ENDIF ELSE BEGIN
	printf,unit,'\hline'
	printf,unit,'\end{tabular}'
	printf,unit,'\end{table}'
ENDELSE
printf,unit,'\end{document}'
free_lun,unit
;
print,'Table saved to: '+file_out
;
end
