pro psn3tex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Prepare LaTeX file from astrometric measurements of a triple star
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
if n_elements(positions) eq 0 then begin
	print,'***Error(PSN3TEX): no astrometry!'
	return
endif
if n_elements(gen_model) eq 0 then begin
	print,'***Error(PSN3TEX): no model!'
	return
endif
;
dates=unique(positions.jy)
comps=unique(positions.component)
num=n_elements(dates)
;
openw,unit,'psn.tex',/get_lun
;
printf,unit,'\documentclass{/home/chummel/latex/aastex502/aastex}'
printf,unit,'\begin{document}'
printf,unit,'\begin{deluxetable}{lcccccrrrrrr}'
printf,unit,'\tablecaption{Observation and result log for ' $
	    +gen_model.starid+'\label{table1}}'
printf,unit,'\tablehead{'
printf,unit,'\colhead{}&'
printf,unit,'\colhead{}&'
printf,unit,'\colhead{} &'
printf,unit,'\colhead{$\sigma_{\rm maj}$}&'
printf,unit,'\colhead{$\sigma_{\rm min}$}&'
printf,unit,'\colhead{$\varphi$}&'
printf,unit,'\colhead{$\rho_{\rm '+comps[0]+'}$}&'
printf,unit,'\colhead{$\theta_{\rm '+comps[0]+'}$}&'
printf,unit,'\colhead{O--C}&'
printf,unit,'\colhead{$\rho_{\rm '+comps[1]+'}$}&'
printf,unit,'\colhead{$\theta_{\rm '+comps[1]+'}$}&'
printf,unit,'\colhead{O--C}'
printf,unit,'\\'
printf,unit,'\colhead{UT Date}&'
printf,unit,'\colhead{Julian Year}&'
printf,unit,'\colhead{$N_{\rm vis.}$}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(deg)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(deg)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(mas)}&'
printf,unit,'\colhead{(deg)}&'
printf,unit,'\colhead{(mas)}'
printf,unit,'\\'
printf,unit,'\colhead{(1)}&'
printf,unit,'\colhead{(2)}&'
printf,unit,'\colhead{(3)}&'
printf,unit,'\colhead{(4)}&'
printf,unit,'\colhead{(5)}&'
printf,unit,'\colhead{(6)}&'
printf,unit,'\colhead{(7)}&'
printf,unit,'\colhead{(8)}&'
printf,unit,'\colhead{(9)}&'
printf,unit,'\colhead{(19)}&'
printf,unit,'\colhead{(11)}&'
printf,unit,'\colhead{(12)}'
printf,unit,'}'
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
RAD=180/!pi
;
printf,unit,'\startdata'
;
for i=0,n_elements(dates)-1 do begin
	i0=where(positions.jy eq dates[i])
	i1=where(positions.jy eq dates[i] and positions.component eq comps[0],i1c)
	i2=where(positions.jy eq dates[i] and positions.component eq comps[1],i2c)
	i0=i0[0]
	i1=i1[0]
	i2=i2[0]
;
	if i1c gt 0 then begin
		rho1=string(positions[i1].rho,format='(f3.1)')
		theta1=string(positions[i1].theta*RAD,format='(f5.1)')
		x=positions[i1].rho*sin(positions[i1].theta)
		y=positions[i1].rho*cos(positions[i1].theta)
		xm=positions[i1].rhom*sin(positions[i1].thetam)
		ym=positions[i1].rhom*cos(positions[i1].thetam)
		oc1=string(sqrt((x-xm)^2+(y-ym)^2),format='(f4.2)')
	endif else begin
		rho1=''
		theta1=''
		oc1=''
	endelse
;
	if i2c gt 0 then begin
		rho2=string(positions[i2].rho,format='(f5.1)')
		theta2=string(positions[i2].theta*RAD,format='(f5.1)')
		x=positions[i2].rho*sin(positions[i2].theta)
		y=positions[i2].rho*cos(positions[i2].theta)
		xm=positions[i2].rhom*sin(positions[i2].thetam)
		ym=positions[i2].rhom*cos(positions[i2].thetam)
		oc2=string(sqrt((x-xm)^2+(y-ym)^2),format='(f4.2)')
	endif else begin
		rho2=''
		theta2=''
		oc2=''
	endelse
;
	parsedate,positions[i0].date,y,m,d
	filename=constrictordate(y,m,d)+'.cha'
	load_interferometry,filename
	ds_options.i=1
	ds_options.a=0
	marquardtdata,y,ysig,ymod
	num_vis=n_elements(y)
	month=months[long(strmid(date,5,2))-1]
	day=strmid(date,8,2)
	printf,unit,month+' '+day+'\dotfill', $
		positions[i0].jy,num_vis, $
		positions[i0].emajor,positions[i0].eminor,positions[i0].pa*RAD, $
		rho1,theta1,oc1,rho2,theta2,oc2, $
		format='(a,"&",f8.3,"&",i4,"&",f4.2,"&",f4.2,"&",f5.1,"&",a,"&",a,"&",a,"&",a,
endfor
;
printf,unit,'\enddata'
;
printf,unit,'\end{deluxetable}'
printf,unit,'\end{document}'
;
free_lun,unit
;
end
