pro pti2tex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
if n_elements(scans) eq 0 then begin
	print,'***Error(PTI2TEX): no interferometry!'
	return
endif
if n_elements(gen_model) eq 0 then begin
	print,'***Error(PTI2TEX): no model!
	return
endif
;
openw,unit,'pti.tex',/get_lun
;
printf,unit,'\documentclass[12pt]{article}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{PTI Observation log for '+gen_model.starid+'}'
printf,unit,'\begin{tabular}{lcccrr} \tableline \tableline'
printf,unit,'&&&'+ $
	    '\multicolumn{1}{c}{Number of}&'+ $
	    '\multicolumn{1}{c}{$\rho_\mathrm{eph.}$}&'+ $
	    '\multicolumn{1}{c}{$\theta_\mathrm{eph.}$}\\'
printf,unit,'\multicolumn{1}{c}{UT Date}&&\multicolumn{1}{c}{Julian Year}&'+ $
	    '\multicolumn{1}{c}{visibilities}&'+ $
	    '\multicolumn{1}{c}{(mas)}&'+ $
	    '\multicolumn{1}{c}{(deg)}\\'
printf,unit,'\multicolumn{1}{c}{(1)}&&'+ $
	    '\multicolumn{1}{c}{(2)}&'+ $
	    '\multicolumn{1}{c}{(3)}&'+ $
	    '\multicolumn{1}{c}{(4)}&'+ $
	    '\multicolumn{1}{c}{(5)}\\ \tableline'
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
parsedate,date,y,m,d
jd=julian(y,m,d)+scans.time/86400
dates=jd2date(jd)
nites=unique(dates)
;
for i=0,n_elements(nites)-1 do begin
	index=where(dates eq nites[i],num_vis)
	jy=jd2jy(avg(jd[index]))
	pos=binarypos(jy2jd(jy))
	month=months[long(strmid(nites[i],5,2))-1]
	day=strmid(nites[i],8,2)
	printf,unit,'\multicolumn{2}{l}{'+month+' '+day+'\dotfill}', $
		jy,num_vis, $
		pos[0],pos[1], $
		format='(a,"&",f9.4,"&",i4,"&",f5.2,"&",f7.2,"\\")'
endfor
;
printf,unit,'\tableline \tableline'
printf,unit,'\end{tabular}'
printf,unit,'\label{table}'
printf,unit,'\end{table}'
printf,unit,'\end{document}'
;
free_lun,unit
return
;
; Version not using aastex
printf,unit,'\documentstyle[12pt]{article}'
printf,unit,'\renewcommand{\baselinestretch}{1.0}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{PTI Observation log for '+gen_model.starid+'}'
printf,unit,'\begin{tabular}{lcccrr} \tableline \tableline'
printf,unit,'&&&'+ $
	    '\multicolumn{1}{c}{Number of}&'+ $
	    '\multicolumn{1}{c}{$\rho_\mathrm{eph.}$}&'+ $
	    '\multicolumn{1}{c}{$\theta_\mathrm{eph.}$}\\'
printf,unit,'\multicolumn{1}{c}{UT Date}&&\multicolumn{1}{c}{Julian Year}&'+ $
	    '\multicolumn{1}{c}{visibilities}&'+ $
	    '\multicolumn{1}{c}{(mas)}&'+ $
	    '\multicolumn{1}{c}{(deg)}\\'
printf,unit,'\multicolumn{1}{c}{(1)}&&'+ $
	    '\multicolumn{1}{c}{(2)}&'+ $
	    '\multicolumn{1}{c}{(3)}&'+ $
	    '\multicolumn{1}{c}{(4)}&'+ $
	    '\multicolumn{1}{c}{(5)}\\ \tableline'
;
printf,unit,'\multicolumn{2}{l}{'+month+' '+day+'\dotfill}', $
		jy,num_vis, $
		pos[0],pos[1], $
		format='(a,"&",f9.4,"&",i4,"&",f5.2,"&",f7.2,"\\")'
;
printf,unit,'\tableline \tableline'
printf,unit,'\end{tabular}'
printf,unit,'\label{table}'
printf,unit,'\end{table}'
printf,unit,'\end{document}'
;
end
