pro put_genconfig
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write GenConfig to HDS file. Erase any existing object of same name.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
;
if checkdata([8]) ne 0 then return
;
if hds_state() eq 0 then begin
	print,'***Error(PUT_SYSCONFIG): no HDS file currently open!'
	return
endif
toplevel
;
put_format,'CHAMELEON'
put_date
put_systemid
put_userid
;
name='GenConfig'
dat_there,name,reply
if reply eq 1 then dat_erase,name
;
ndim=0L
dims=lonarr(7)
;
type='GENCONFIG'
dat_new,name,type,ndim,dims
dat_find,name
;
name='InstrCohInt'
type='_double'
dat_new,name,type,ndim,dims
value=GenConfig.InstrCohInt
cmp_put0d,name,value
;
name='BeamCombinerId'
type='_integer'
dat_new,name,type,ndim,dims
value=GenConfig.BeamCombinerId
cmp_put0i,name,value
;
; Added 2006-11-14
name='ConfigId'
len=strlen(GenConfig.ConfigId)
dat_new0c,name,len
cmp_put0c,name,GenConfig.ConfigId
;
name='NumBin'
type='_integer'
dat_new,name,type,ndim,dims
value=GenConfig.NumBin
cmp_put0i,name,value
;
name='Refstation'
type='_integer'
dat_new,name,type,ndim,dims
value=GenConfig.refstation
cmp_put0i,name,value
;
name='InputBeam'
type='TABLE'
dat_new,name,type,ndim,dims
dat_find,name
;
	name='NumSid'
	ndim=0L
	type='_integer'
	value=GenConfig.NumSid
	dat_new,name,type,ndim,dims
	cmp_put0i,name,value
;
	name='SiderostatId'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.SiderostatId[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='SidConId'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.SidConId[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='BCInputId'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.BCInputId[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='StartrackerId'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.StartrackerId[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='StationId'
	ndim=1L
	dims[0]=GenConfig.NumSid
	data=GenConfig.StationId[0:dims[0]-1]
	type='_char*'+strcompress(string(strlen(data[0])),/remove_all)
	dat_new,name,type,ndim,dims
	cmp_put1c,name,data
;
	name='DelayLineId'
	type='_integer'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.DelayLineId[0:dims[0]-1]
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='StationCoord'
	ndim=2L
	dims[0]=4
	dims[1]=GenConfig.NumSid
	values=GenConfig.StationCoord[0:dims[0]-1,0:dims[1]-1]
	type='_double'
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
;
	name='Stroke'
	type='_real'
	ndim=1L
	dims[0]=GenConfig.NumSid
	values=GenConfig.Stroke[0:dims[0]-1]
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	dat_annul
;
name='OutputBeam'
type='TABLE'
ndim=0L
dat_new,name,type,ndim,dims
dat_find,name
;
	name='NumOutBeam'
	ndim=0L
	value=GenConfig.NumOutBeam
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put0i,name,value
;
	name='NumBaseline'
	ndim=1L
	dims[0]=GenConfig.NumOutBeam
	values=GenConfig.NumBaseline[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='NumBiasFreq'
	ndim=1L
	dims[0]=GenConfig.NumOutBeam
	values=GenConfig.NumBiasFreq[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='NumSpecChan'
	ndim=1L
	dims[0]=GenConfig.NumOutBeam
	values=GenConfig.NumSpecChan[0:dims[0]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='SpectrometerId'
	ndim=1L
	dims[0]=GenConfig.NumOutBeam
	data=GenConfig.SpectrometerId[0:dims[0]-1]
	type='_char*'+strcompress(string(strlen(data[0])),/remove_all)
	dat_new,name,type,ndim,dims
	cmp_put1c,name,data
;
	name='BaselineId'
	ndim=2L
	dims[0]=max(GenConfig.NumBaseline)
	dims[1]=GenConfig.NumOutBeam
	data=GenConfig.BaselineId[0:dims[0]-1,0:dims[1]-1]
	type='_char*'+strcompress(string(strlen(data[0])),/remove_all)
	dat_new,name,type,ndim,dims
	cmp_putnc,name,ndim,dims,data
;
	name='Wavelength'
	ndim=2L
	dims[0]=max(GenConfig.NumSpecChan)
	dims[1]=GenConfig.NumOutBeam
	values=GenConfig.Wavelength[0:dims[0]-1,0:dims[1]-1]
	type='_double'
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
	name='WavelengthErr'
	values=GenConfig.WavelengthErr[0:dims[0]-1,0:dims[1]-1]
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
	name='ChanWidth'
	values=GenConfig.ChanWidth[0:dims[0]-1,0:dims[1]-1]
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
	name='ChanWidthErr'
	values=GenConfig.ChanWidthErr[0:dims[0]-1,0:dims[1]-1]
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
;
	name='Bias'
	ndim=5L
	dims[0]=2
	dims[1]=max(GenConfig.NumBaseline)
	dims[2]=max(GenConfig.NumSpecChan)
	dims[3]=GenConfig.NumOutBeam
	maxConfig=system_config(SystemId,'MAXCONFIG')
	case string(maxConfig) of
		'scans':maxConfig=scanconfig(/maxconfig)
		'stars':maxConfig=n_elements(scanconfig(/starlist))
		   else:maxConfig=fix(maxConfig)
	endcase
	dims[4]=maxConfig
	values=double(GenConfig.V2Bias[0:dims[0]-1, $
				       0:dims[1]-1, $
				       0:dims[2]-1, $
				       0:dims[3]-1, $
				       0:dims[4]-1])
	type='_double'
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
;
  	name='FringeMod'
	ndim=2L
	dims[0]=max(GenConfig.NumBaseline)
	dims[1]=GenConfig.NumOutBeam
	values=GenConfig.FringeMod[0:dims[0]-1,0:dims[1]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_putni,name,ndim,dims,values
;
  	name='BiasMod'
	ndim=2L
	dims[0]=max(GenConfig.NumBaseline)
	dims[1]=GenConfig.NumOutBeam
	values=GenConfig.BiasMod[0:dims[0]-1,0:dims[1]-1]
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_putni,name,ndim,dims,values
;
	dat_annul
;
if GenConfig.NumTriple gt 0 then begin
name='Triple'
type='TABLE'
ndim=0L
dat_new,name,type,ndim,dims
dat_find,name
;
	name='NumTriple'
	ndim=0L
	value=GenConfig.NumTriple
	type='_integer'
	dat_new,name,type,ndim,dims
	cmp_put0i,name,value
;
	name='OutputBeam'
	ndim=2L
	dims[0]=3
	dims[1]=GenConfig.NumTriple
	values=GenConfig.TripleBeam[0:dims[0]-1,0:dims[1]-1]
	dat_new,name,type,ndim,dims
	cmp_putni,name,ndim,dims,values
;
	name='Baseline'
	values=GenConfig.TripleBase[0:dims[0]-1,0:dims[1]-1]
	dat_new,name,type,ndim,dims
	cmp_putni,name,ndim,dims,values
;
	name='SpecChan'
	ndim=3L
	dims[0]=max(GenConfig.NumSpecChan)
	dims[1]=3
	dims[2]=GenConfig.NumTriple
	values=GenConfig.TripleChan[0:dims[0]-1,0:dims[1]-1,0:dims[2]-1]
	dat_new,name,type,ndim,dims
	cmp_putni,name,ndim,dims,values
;
	name='NumSpecChan'
	ndim=1L
	dims[0]=GenConfig.NumTriple
	values=GenConfig.TripleNumChan[0:dims[0]-1]
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='Bias'
	ndim=4L
	dims[0]=2
	dims[1]=max(GenConfig.NumSpecChan)
	dims[2]=GenConfig.NumTriple
	maxConfig=system_config(SystemId,'MAXCONFIG')
	case string(maxConfig) of
		'scans':maxConfig=scanconfig(/maxconfig)
		'stars':maxConfig=n_elements(scanconfig(/starlist))
		   else:maxConfig=fix(maxConfig)
	endcase
	dims[3]=maxConfig
	values=double(GenConfig.TABias[0:dims[0]-1, $
				       0:dims[1]-1, $
				       0:dims[2]-1, $
				       0:dims[3]-1])
	type='_double'
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,values
;
	dat_annul
;
endif
;
dat_annul
;
end
