pro put_mark3data
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write Mark III data in cal file format.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
;
if n_elements(SystemId) eq 0 then begin
	print,'***Error(PUT_MARK3DATA): SystemId undefined!'
	return
endif
if SystemId ne 'Mark3' then begin
	print,'***Error(PUT_MARK3DATA): SystemId is not Mark3!'
	return
endif
;
parsedate,Date,y,m,d
mark3_date=(y-1900)*10000L+m*100+d
;
mark3_ch1=GenConfig.Wavelength[0,0]*1.d9
mark3_ch2=GenConfig.Wavelength[0,1]*1.d9
mark3_ch3=GenConfig.Wavelength[1,0]*1.d9
mark3_ch4=GenConfig.Wavelength[1,1]*1.d9
;
i=where(mark3_baselines eq GenConfig.BaselineId[0],count)
if count eq 0 then begin
	print,'***Error(PUT_MARK3DATA): unknown baseline: ', $
		GenConfig.BaselineId[0],'!'
	return
endif
mark3_baseline=i[0]+1
;
index=where(scans.time gt 0,count)
if count eq 0 then begin
	print,'***Error(PUT_MARK3DATA): no valid scans to write!'
	return
endif
mark3_scans=scans[index]
;
; Prepare star numbers
stars=scans[index].starid
; Replace MARK_III BSC numbers with corresponding FKV numbers >= 1700
for i=0,n_elements(mark3_bsc)-1 do begin
	index=where(stars eq mark3_bsc[i],count)
	if count gt 0 then stars[index]=mark3_cat[i]
endfor
mark3_stars=fix(strmid(stars,3,4))
;
filename=strcompress(string(mark3_date),/remove_all)+'m3.cal'
openw,unit,filename,/get_lun
;
dot='.'
printf,unit,mark3_date,dot,mark3_baseline,mark3_ch2,mark3_ch3,mark3_ch4, $
	format='(3x,i6,a1,3x,i2,2x,f5.1,17x,f5.1,17x,f5.1)'
for i=0,n_elements(mark3_scans)-1 do begin
	v2=scans[i].VisSq(1,0,0)
     	vc2=scans[i].VisSqC(1,0,0)
     	vce2=scans[i].VisSqCErr(1,0,0)
	if vce2 lt 0 then begin
		vc2=2.0
		vce2=0.0
	endif
     	v3=scans[i].VisSq(0,1,0)
     	vc3=scans[i].VisSqC(0,1,0)
     	vce3=scans[i].VisSqCErr(0,1,0)
	if vce3 lt 0 then begin
		vc3=2.0
		vce3=0.0
	endif
     	v4=scans[i].VisSq(1,1,0)
     	vc4=scans[i].VisSqC(1,1,0)
     	vce4=scans[i].VisSqCErr(1,1,0)
	if vce4 lt 0 then begin
		vc4=2.0
		vce4=0.0
	endif
     	printf,unit,scans[i].time/3600,mark3_stars[i], $
       		v2,vc2,vce2,v3,vc3,vce3,v4,vc4,vce4, $
       		format='(1x,f9.6,1x,i4,3(1x,f6.3),1x,3(1x,f6.3),1x,3(1x,f6.3))'
endfor
free_lun,unit
print,'Mark3 data written.'
;
end
