pro put_metroconfig
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write MetroConfig to HDS file. Erase any existing object of same name.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
;
if checkdata([21]) ne 0 then return
;
if hds_state() eq 0 then begin
	print,'***Error(PUT_METROCONFIG): no HDS file currently open!'
	return
endif
;
toplevel
;
ndim=0L
dims=lonarr(7)
;
name='MetroConfig'
dat_there,name,reply
if reply eq 1 then dat_erase,name
dat_new,name,name,ndim,dims
dat_find,name
;
name='SidModel'
ndim=1L
dims[0]=GenConfig.NumSid
type='TABLE'
dat_new,name,type,ndim,dims
dat_find,name
;
for i=0,GenConfig.NumSid-1 do begin
;
	ndim=1L
	dat_cell,ndim,i+1
;
	ndim=1L
	dims[0]=2
	type='_double'
;
	name='FeedBeamAng'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.FeedBeamAng[*,i]
	cmp_put1d,name,values
;
	name='FeedBeamAngErr'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.FeedBeamAngErr[*,i]
	cmp_put1d,name,values
;
	name='SidAng'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.SidAng[*,i]
	cmp_put1d,name,values
;
	name='SidAngErr'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.SidAngErr[*,i]
	cmp_put1d,name,values
;
	name='ZeroAng'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.ZeroAng[*,i]
	cmp_put1d,name,values
;
	name='ZeroAngErr'
	dat_new,name,type,ndim,dims
	values=MetroConfig.SidModel.ZeroAngErr[*,i]
	cmp_put1d,name,values
;
	ndim=0L
;
	name='AxisOffAng'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.AxisOffAng[i]
	cmp_put0d,name,value
;
	name='AxisOffAngErr'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.AxisOffAngErr[i]
	cmp_put0d,name,value
;
	name='MirrorOffAng'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.MirrorOffAng[i]
	cmp_put0d,name,value
;
	name='MirrorOffAngErr'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.MirrorOffAngErr[i]
	cmp_put0d,name,value
;
	name='CatsEyeOff'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.CatsEyeOff[i]
	cmp_put0d,name,value
;
	name='CatsEyeOffErr'
	dat_new,name,type,ndim,dims
	value=MetroConfig.SidModel.CatsEyeOffErr[i]
	cmp_put0d,name,value
;
	dat_annul
;
endfor
;
dat_annul
dat_annul
;
end
