pro put_oifits,fitsfile,multiple=multiple,starid=starid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write averaged data from multiple nights and arrays into new OI-FITS format.
; Different beam combiner outputs are treated as different interferometers,
; i.e. instruments of the same array. They all should have their own wavelength
; tables, but in the case of them all being identical (simple_oiwave=1), this
; procedure writes out only one and stores the different output beams as
; different baselines.
;
; If there is more than one unique beam combiner output (simple_oiwave=0),
; and a triple is made up of baselines coming from more than one of them,
; the channel wavelengths are taken from the first baseline defined.
; Therefore, this procedure cannot handle the (in any case invalid) combination
; of data from different channels into one triple (simple_oitriple=0).
;
; If keyword Multiple not set, only save the current data.
; Select a specific target if the OIFITS reader only processes single target
; files.
;
forward_function concat_oitable
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if not keyword_set(multiple) then multiple=0
nndex=indgen(n_elements(geninfo))
count=n_elements(geninfo)
if not multiple then nndex=where(geninfo.date eq genconfig.date $
			     and geninfo.configid eq genconfig.configid $
			     and geoinfo.systemid eq geoparms.systemid,count)
;
arrays=unique(geoinfo[nndex].systemid)
num_arrays=n_elements(arrays)
print,'Number of arrays found: ',num_arrays
print,arrays
;
nights=unique(geninfo[nndex].date)
num_nights=n_elements(nights)
print,'Number of nights',num_nights
print,nights
;
num_sets=n_elements(geninfo[nndex])
print,'Number of data sets:',num_sets
;
; Make backup copy of data
startable_bck=startable
scantable_bck=scantable
scans_bck=scans
;
if n_elements(starid) ne 0 then begin
	index=where(startable.starid eq starid,count)
	if count eq 0 then begin
	index=where(startable.name eq starid,count)
	if count eq 0 then begin
		print,'Target not found!'
		return
	endif
	endif
	startable=startable[index]
endif
stars=startable.starid
; mask=intarr(n_elements(stars))
; for i=0,n_elements(stars) -1 do $
; 	mask(where(startable.starid eq stars(i)))=1
; startable=startable(where(mask eq 1))
;
; Assemble target information
define_oitarget,oitarget_unit
oitarget=replicate(oitarget_unit,n_elements(startable))
oitarget[*].target_id = indgen(n_elements(startable))
oitarget[*].target = startable.starid
oitarget[*].raep0 = startable.ra*15
oitarget[*].decep0 = startable.dec
oitarget[*].equinox = 2000.0
oitarget[*].ra_err = startable.rae
oitarget[*].dec_err = startable.dece
oitarget[*].sysvel = startable.rv
oitarget[*].veltyp = "LSR"
oitarget[*].veldef = "OPTICAL"
oitarget[*].pmra = startable.pmra
oitarget[*].pmdec = startable.pmdec
oitarget[*].pmra_err = startable.pmrae
oitarget[*].pmdec_err = startable.pmdece
oitarget[*].parallax = startable.px
oitarget[*].para_err = startable.pxe
oitarget[*].spectyp = startable.spectrum
; Update for OI_TARGET revision 2
; oitarget(*).nwave=n_elements(startable(0).wvl)
; oitarget(*).nx=n_elements(startable(0).img(*,0))
; oitarget(*).ny=n_elements(startable(0).img(0,*))
; for i=0,n_elements(startable)-1 do begin
; oitarget(i).flux=ptr_new(float(startable(i).sed))
; oitarget(i).wave=ptr_new(float(startable(i).wvl))
; oitarget(i).img =ptr_new(float(startable(i).img))
; endfor
;
; Allocate array data
define_oiarray,oiarray_unit
oiarray=replicate(oiarray_unit,long(total(geninfo[nndex].numsid)))
i0=0
;
oiwavelength_ver=1
oivis_ver=1
oivis2_ver=1
oit3_ver=1
;
FOR n=0,num_sets-1 do BEGIN
;
;	Make copy of genconfig for more readibility of code
	g=genconfig
;
	if num_sets gt 1 then $
	loadnight,geninfo[nndex[n]].date, $
		  geoinfo[nndex[n]].systemid, $
		  geninfo[nndex[n]].configid
;
; 	Assemble array information
	geoparms=geoinfo[nndex[n]]
	index=indgen(g.numsid)+i0
	oiarray[index].extver=n+1
	array_name=system_id(systemid)
	oiarray[index].arrname=array_name
	oiarray[index].frame="GEOCENTRIC"
;
	RAD=180/pi_circle
	gstia0=ut12gst(0)*15.d0
	ut1utc=geoparms.ut1utc_coeffs[0]
	datutc=geoparms.tai_utc
	r_earth=6378.136d3
	arrayc=(r_earth+geoparms.altitude)* $
		[cos(geoparms.latitude/RAD)*cos(geoparms.longitude/RAD), $
	 	 cos(geoparms.latitude/RAD)*sin(geoparms.longitude/RAD), $
	 	 sin(geoparms.latitude/RAD)]
	oiarray[index].arrayx=arrayc[0]
	oiarray[index].arrayy=arrayc[1]
	oiarray[index].arrayz=arrayc[2]
;
	stations=strarr(g.numsid)
	telescopes=strarr(g.numsid)
	stncoord=dblarr(3,g.numsid)
	for i=0,g.numsid-1 do begin
;		Bring into geocentric system via equatorial
		npoi_x=GenConfig.StationCoord[0,i]
		npoi_y=GenConfig.StationCoord[1,i]
		npoi_z=GenConfig.StationCoord[2,i]
		x=cos(GeoParms.Latitude/RAD)*npoi_z $
		 -sin(GeoParms.Latitude/RAD)*npoi_y
		y=npoi_x
		z=cos(GeoParms.Latitude/RAD)*npoi_y $
		 +sin(GeoParms.Latitude/RAD)*npoi_z
		stncoord[*,i]=equatorial2geocentric([x,y,z])
		stations[i]=g.stationid[i]
		telescopes[i]='SID'+strtrim(string(g.siderostatid[i]),2)
	endfor
	oiarray[index].tel_name=telescopes
	oiarray[index].sta_name=stations
	oiarray[index].sta_index=indgen(g.numsid)
	oiarray[index].diameter=fltarr(g.numsid)+0.12
	for i=0,g.numsid-1 do oiarray[index[i]].staxyz=stncoord[*,i]
;
	i0=i0+g.numsid
;
;	Assemble data for this night
;
	mask=intarr(n_elements(scans))
	for i=0,n_elements(stars)-1 do begin
		index=where(scans.starid eq stars[i],count)
		if count gt 0 then mask[index]=1
	endfor
	index=where(mask eq 1,count)
	IF count gt 0 then BEGIN
	scans=scans[index]
	scantable=scantable[index]
	target_ids=intarr(n_elements(scans))
	for j=0,n_elements(scans)-1 do $
		target_ids[j]=where(startable.starid eq scans[j].starid)
;	Test if all interferometers (i.e. OBs) have the same wavelengths
	simple_oiwave=1
	if total(g.numspecchan[0:g.numoutbeam-1] $
		-g.numspecchan[0]) ne 0 $
		then simple_oiwave=0
	for j=0,g.numspecchan[0]-1 do begin
		for k=1,g.numoutbeam-1 do $
		if abs(g.wavelength[j,k]-g.wavelength[j,0]) $
		gt 2e-9 then simple_oiwave=0
	endfor
	for i=0,g.numoutbeam-1 do begin
		nw=g.numspecchan[i]
; 		Assemble wavelength information
		define_oiwavelength,oiwavelength_unit,nw=nw
		instrument=instrument_id(system_id(systemid))
		if not simple_oiwave then $
			instrument=instrument+'_OB'+string(i+1,format='(i2.2)')
		if n_elements(oiwavelength) eq 0 then begin
			oiwavelength=oiwavelength_unit
			oiwavelength.extver=oiwavelength_ver
			oiwavelength.insname=instrument
			oiwavelength.eff_wave= $
				ptr_new(float(g.wavelength[0:nw-1,i]))
			oiwavelength.eff_band= $
				ptr_new(float(g.chanwidth[0:nw-1,i]))
			oiwavelength_ver=oiwavelength_ver+1
		endif
		j=where(oiwavelength.insname eq instrument,jn)
		if jn eq 0 then begin
			oiwavelength=concat_oitable(oiwavelength, $
						    oiwavelength_unit)
			k=oiwavelength_ver-1
			oiwavelength[k].extver=oiwavelength_ver
			oiwavelength[k].insname=instrument
			oiwavelength[k].eff_wave= $
				ptr_new(float(g.wavelength[0:nw-1,i]))
			oiwavelength[k].eff_band= $
				ptr_new(float(g.chanwidth[0:nw-1,i]))
			oiwavelength_ver=oiwavelength_ver+1
		endif
;		Loop over baselines in this spectrometer
		for l=0,g.numbaseline[i]-1 do begin
;		Assemble complex visibility data
		jndex=where(scans.complexweight[i,*,*] ne 0,count)
		if count gt 0 then begin
		define_oivis,oivis_unit,nw=nw
		if n_elements(oivis) ne 0 then oivis0=oivis
		oivis=replicate(oivis_unit,n_elements(scans))
		oivis[*].extver=oivis_ver
		oivis_ver=oivis_ver+1
		oivis[*].date_obs=geoinfo[nndex[n]].date
		oivis[*].arrname=array_name
		oivis[*].insname=instrument
		oivis[*].target_id=target_ids
		oivis[*].time=abs(scans.time)
		parsedate,geoparms.date,y,m,d
		oivis[*].mjd=julian(y,m,d)-2400000.5+abs(scans.time)/86400
		oivis[*].int_time=scans.int_time
		for j=0,n_elements(scans)-1 do begin
			amp=abs(scans[j].complexvis(i,0:nw-1,l))
			phi=cphase(scans[j].complexvis(i,0:nw-1,l))*RAD
			oivis[j].visamp=ptr_new(float(amp))
			oivis[j].visphi=ptr_new(float(phi))
			weight=scans[j].complexweight(i,0:nw-1,l)
			sig=weight*0
			jndex=where(weight ne 0,count)
			if count gt 0 then sig[jndex]=1/sqrt(weight[jndex])
                        jndex=where(weight eq 0,count)
                        if count gt 0 then amp[jndex]=1
			oivis[j].visamperr=ptr_new(sig)
			oivis[j].visphierr=ptr_new(sig/amp*RAD)
			oivis[j].ucoord=scans[j].uvw(i,0,l,0)*g.wavelength[0,i]
			oivis[j].vcoord=scans[j].uvw(i,0,l,1)*g.wavelength[0,i]
			si=where(g.stationid eq $
			  strmid(g.baselineid[l,i],0,3))
			sj=where(g.stationid eq $
			  strmid(g.baselineid[l,i],4,3))
			oivis[j].sta_index=[si,sj]
			flags=strarr(nw)+'F'
			fndex=where(scans[j].complexweight(i,0:nw-1,l) eq 0,count)
			if count gt 0 then flags[fndex]='T'
			oivis[j].flag=ptr_new(reform(byte(flags)))
		endfor
		if n ne 0 or i ne 0 or l ne 0 then $
			oivis=concat_oitable(oivis0,oivis)
		endif
		endfor
;		Assemble squared visibility data
		for l=0,g.numbaseline[i]-1 do begin
		define_oivis2,oivis2_unit,nw=nw
		if n_elements(oivis2) ne 0 then oivis0=oivis2
		oivis2=replicate(oivis2_unit,n_elements(scans))
		oivis2[*].extver=oivis2_ver
		oivis2_ver=oivis2_ver+1
		oivis2[*].date_obs=geoinfo[nndex[n]].date
		oivis2[*].arrname=array_name
		oivis2[*].insname=instrument
		oivis2[*].target_id=target_ids
		oivis2[*].time=abs(scans.time)
		parsedate,geoparms.date,y,m,d
		oivis2[*].mjd=julian(y,m,d)-2400000.5+abs(scans.time)/86400
		oivis2[*].int_time=scans.int_time
		for j=0,n_elements(scans)-1 do begin
			oivis2[j].vis2data= $
			ptr_new(scans[j].vissqc(i,0:nw-1,l))
			oivis2[j].vis2err= $
			ptr_new(scans[j].vissqcerr(i,0:nw-1,l))
			oivis2[j].ucoord=scans[j].uvw(i,0,l,0)*g.wavelength[0,i]
			oivis2[j].vcoord=scans[j].uvw(i,0,l,1)*g.wavelength[0,i]
			si=where(g.stationid eq strmid(g.baselineid[l,i],0,3))
			sj=where(g.stationid eq strmid(g.baselineid[l,i],4,3))
			oivis2[j].sta_index=[si,sj]
			flags=strarr(nw)+'F'
			fndex=where(scans[j].vissqcerr(i,0:nw-1,l) lt 0,count)
			if count gt 0 then flags[fndex]='T'
			oivis2[j].flag=ptr_new(reform(byte(flags)))
		endfor
		if n ne 0 or i ne 0 or l ne 0 then $
			oivis2=concat_oitable(oivis0,oivis2)
		endfor
	endfor
;	Assemble triple product data
	for i=0,g.numtriple-1 do begin
		nw=g.triplenumchan[i]
; 		Assemble wavelength information
		define_oiwavelength,oiwavelength_unit,nw=nw
		instrument=instrument_id(system_id(systemid))
		if not simple_oiwave then begin
			if total(g.triplebeam[*,i] $
				-g.triplebeam[0,i]) eq 0 then begin
			instrument=instrument $
				  +'_OB'+string(g.triplebeam[0,i]+1, $
				  		format='(i2.2)')
			simple_oitriple=1
			endif else begin
			instrument=instrument $
				  +'_TR'+string(i+1,format='(i2.2)')
			simple_oitriple=0
			endelse
		endif else simple_oitriple=1
		if n_elements(oiwavelength) eq 0 then begin
			oiwavelength=oiwavelength_unit
			oiwavelength.extver=oiwavelength_ver
			oiwavelength.insname=instrument
;			Assume identical wavelengths on each baseline
			oiwavelength.eff_wave= $
				ptr_new(float(g.wavelength[ $
					g.triplechan[0:nw-1,0,i], $
					g.triplebeam[0,i]]))
			oiwavelength.eff_band= $
				ptr_new(float(g.chanwidth[ $
					g.triplechan[0:nw-1,0,i], $
					g.triplebeam[0,i]]))
			oiwavelength_ver=oiwavelength_ver+1
;		Do not create a new wavelength table entry if not needed
		endif else if not simple_oiwave and not simple_oitriple then begin
			oiwavelength=concat_oitable(oiwavelength, $
						    oiwavelength_unit)
			k=oiwavelength_ver-1
			oiwavelength[k].extver=oiwavelength_ver
			oiwavelength[k].insname=instrument
			oiwavelength[k].eff_wave= $
				ptr_new(float(g.wavelength[ $
					g.triplechan[0:nw-1,0,i], $
					g.triplebeam[0,i]]))
			oiwavelength[k].eff_band= $
				ptr_new(float(g.chanwidth[ $
					g.triplechan[0:nw-1,0,i], $
					g.triplebeam[0,i]]))
			oiwavelength_ver=oiwavelength_ver+1
		endif
		define_oit3,oit3_unit,nwave=nw
		if n_elements(oit3) ne 0 then oit0=oit3
		oit3=replicate(oit3_unit,n_elements(scans))
		oit3[*].extver=oit3_ver
		oit3_ver=oit3_ver+1
		oit3[*].date_obs=geoinfo[nndex[n]].date
		oit3[*].arrname=array_name
		oit3[*].insname=instrument
		oit3[*].target_id=target_ids
		oit3[*].time=abs(scans.time)
		oit3[*].mjd=julian(y,m,d)-2400000.5+abs(scans.time)/86400
		oit3[*].int_time=scans.int_time
		for j=0,n_elements(scans)-1 do begin
			oit3[j].t3amp= $
				ptr_new(scans[j].tripleampc(i,0:nw-1))
			oit3[j].t3amperr= $
				ptr_new(scans[j].tripleampcerr(i,0:nw-1))
			oit3[j].t3phi= $
				ptr_new(-scans[j].triplephasec(i,0:nw-1)*RAD)	; 			Flip sign (Iota Peg)
			oit3[j].t3phierr= $
				ptr_new(scans[j].triplephasecerr(i,0:nw-1)*RAD)
			baselineids=g.baselineid[ $
			   g.triplebase[*,i],g.triplebeam[*,i]]
			si=where(g.stationid eq strmid(baselineids[0],0,3))
			sj=where(g.stationid eq strmid(baselineids[0],4,3))
			sk=where(g.stationid eq strmid(baselineids[1],0,3))
			if sk eq si or sk eq sj then $
			sk=where(g.stationid eq strmid(baselineids[1],4,3))
;			The rule requires a triple 12,23,31
			baselinereq=[baselineids[0], $
				g.stationid[sj]+'-'+g.stationid[sk], $
				g.stationid[sk]+'-'+g.stationid[si]]
			idx=intarr(3)	; To reorder the baseline
			fbf=fltarr(3)+1 ; To apply to a reversed baseline
			for l=0,2 do begin
				idx[l]=where(baselineids eq baselinereq[l] or $
				       breve(baselineids) eq baselinereq[l])
				if baselineids[idx[l]] ne baselinereq[l] then $
					fbf[l]=-1
			endfor
			oit3[j].sta_index=[si,sj,sk]
			oit3[j].u1coord=scans[j].uvw( $
					g.triplebeam[idx[0],i],0, $
					g.triplebase[idx[0],i],0) $
				*g.wavelength[0,g.triplebeam[idx[0],i]]*fbf[0]
			oit3[j].v1coord=scans[j].uvw( $
					g.triplebeam[idx[0],i],0, $
					g.triplebase[idx[0],i],1) $
				*g.wavelength[0,g.triplebeam[idx[0],i]]*fbf[0]
			oit3[j].u2coord=scans[j].uvw( $
					g.triplebeam[idx[1],i],0, $
					g.triplebase[idx[1],i],0) $
				*g.wavelength[0,g.triplebeam[idx[1],i]]*fbf[1]
			oit3[j].v2coord=scans[j].uvw( $
					g.triplebeam[idx[1],i],0, $
					g.triplebase[idx[1],i],1) $
				*g.wavelength[0,g.triplebeam[idx[1],i]]*fbf[1]
			flags=strarr(nw)+'F'
			fndex=where(scans[j].tripleampcerr(i,0:nw-1) lt 0 $
				 or scans[j].triplephasecerr(i,0:nw-1) lt 0, $
					count)
			if count gt 0 then flags[fndex]='T'
			oit3[j].flag=ptr_new(reform(byte(flags)))
		endfor
		if n ne 0 or i ne 0 then $
			oit3=concat_oitable(oit0,oit3)
		endfor
		ENDIF
;
ENDFOR
;
; Restore data
startable=startable_bck
scantable=scantable_bck
scans=scans_bck
;
; Write OI-FITS data
if n_elements(fitsfile) eq 0 then begin
	if keyword_set(starid) then fitsfile=starid+'_'+Date+'.fits' $
			       else fitsfile=Date+'.fits'
endif
if strlen(extname(fitsfile)) eq 0 then fitsfile=fitsfile+'.fits'
;
write_oidata,fitsfile,oiarray,oitarget,oiwavelength,oivis,oivis2,oit3
print,'OIFITS data saved to: '+fitsfile
;
end
