pro put_oitarget,fitsfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write StarTable to disk in OIFITS format, i.e. OI_TARGET table revision 2.
;
common Tables,ScanTable,BGTable,StationTable
common StarBase,StarTable,Notes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
stars=startable.starid
table=startable
mask=intarr(n_elements(startable))
for i=0,n_elements(stars) -1 do $
	mask[where(startable.starid eq stars[i])]=1
startable=startable[where(mask eq 1)]
;
; Assemble target information
define_oitarget,oitarget_unit
oitarget=replicate(oitarget_unit,n_elements(startable))
oitarget[*].target_id = indgen(n_elements(startable))
oitarget[*].target = startable.starid
oitarget[*].raep0 = startable.ra*15
oitarget[*].decep0 = startable.dec
oitarget[*].equinox = 2000.0
oitarget[*].ra_err = startable.rae
oitarget[*].dec_err = startable.dece
oitarget[*].sysvel = startable.rv
oitarget[*].veltyp = "LSR"
oitarget[*].veldef = "OPTICAL"
oitarget[*].pmra = startable.pmra
oitarget[*].pmdec = startable.pmdec
oitarget[*].pmra_err = startable.pmrae
oitarget[*].pmdec_err = startable.pmdece
oitarget[*].parallax = startable.px
oitarget[*].para_err = startable.pxe
oitarget[*].spectyp = startable.spectrum
; Update for OI_TARGET revision 2
oitarget[*].diameter=startable.diameter
oitarget[*].omega=startable.omega
oitarget[*].vsini=startable.vsini
oitarget[*].tilt=startable.tilt
oitarget[*].rapa=startable.rapa
oitarget[*].mass=startable.mass
oitarget[*].teff=startable.teff
oitarget[*].logg=startable.logg
oitarget[*].zexp=startable.zexp
oitarget[*].nwave=n_elements(startable[0].wvl)
for i=0,n_elements(startable)-1 do begin
	oitarget[i].wave=ptr_new(float(startable[i].wvl))
	oitarget[i].flux=ptr_new(float(startable[i].sed))
	oitarget[i].lldc=ptr_new(float(startable[i].ldc))
endfor
;
; Write OI FITS data
if n_elements(fitsfile) eq 0 then fitsfile='oitarget.fits'
write_oidata,fitsfile,0,oitarget,0,0,0,0
print,'OIFITS data saved to: '+fitsfile
;
end
