pro put_scandata,file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write scan data and related tables to file. File is updated if it already
; exists, otherwise it will be created.
;
if hds_state() eq 0 then begin
	if n_elements(file) eq 0 then begin
		print,'***Error(PUT_SCANDATA): file not specified!'
		return
	endif
	result=file_search(file,count=fcount)
	if fcount ne 0 then hds_open,file,'UPDATE',status else $
        	hds_new,file,'DataSet','CHAMELEON',status
	if status ne 0 then begin
        	print,'***Error(PUT_SCANDATA): file problem!'
        	clearstatus
        	return
	endif
endif else begin
	print,'***Error(PUT_SCANDATA): please close the current file first!'
	return
endelse
;
put_scanlog
put_observerlog
put_constrictorlog
put_sysconfig
put_scans
;
hds_close
;
end
