pro put_scans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write averaged scandata to HDS file. Erases any object with same name.
; HDS file must have been opened before calling this procedure.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if hds_state() eq 0 then begin
	print,'***Error(PUT_SCANDATA): no HDS file currently open!'
	return
endif
toplevel
;
; For astrometry, remove corrections from delays first
whitecorr,/remove
pivotcorr,/remove
;
; We need to remove the dead time correction, but leave the current data intact
scans_bck=scans
; deadcorr,/remove
;
name='SCANDATA'
dat_there,name,reply
if reply eq 1 then dat_erase,name
type='TABLE'
ndim=0L
dims=lonarr(7)
dat_new,name,type,ndim,dims
dat_find,name
	name='NumScan'
	type='_integer'
	ndim=0L
	dat_new,name,type,ndim,dims
	value=n_elements(scans)
	cmp_put0i,name,value
;
	name='ScanId'
	type='_integer'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	dat_new,name,type,ndim,dims
	values=ScanTable.ScanId
	cmp_put1i,name,values
;
	name='Code'
	type='_integer'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	dat_new,name,type,ndim,dims
	values=ScanTable.Code
	cmp_put1i,name,values
;
	name='Station'
	type='_integer'
	ndim=2L
	dims[0]=GenConfig.NumSid
	dims[1]=n_elements(ScanTable)
	dat_new,name,type,ndim,dims
	values=ScanTable.Station[0:GenConfig.NumSid-1]
	cmp_putni,name,ndim,dims,values
;
	name='StarId'
	data=ScanTable.StarId
	type='_char*'+strcompress(string(max(strlen(data))),/remove_all)
	ndim=1L
	dims[0]=n_elements(ScanTable)
	dat_new,name,type,ndim,dims
	cmp_put1c,name,data
;
	name='Star'
	data=scans.Star
	type='_char*'+strcompress(string((max(strlen(data))>1)),/remove_all)
	ndim=1L
	dims[0]=n_elements(ScanTable)
	dat_new,name,type,ndim,dims
	cmp_put1c,name,data
;
	name='RA'
	type='_double'
	ndim=1L
	dims[0]=n_elements(scans)
	values=scans.RA
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='Dec'
	type='_double'
	ndim=1L
	dims[0]=n_elements(scans)
	values=scans.Dec
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='ScanTime'
	type='_double'
	ndim=1L
	dims[0]=n_elements(scans)
	values=scans.Time
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='StartTime'
	type='_double'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=ScanTable.StartTime
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='StopTime'
	type='_double'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=ScanTable.StopTime
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='Int_Time'
	type='_double'
	ndim=1L
	dims[0]=n_elements(scans)
	values=scans.Int_Time
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='NumPoint'
	type='_integer'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=ScanTable.NumPoint
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='NumCoh'
	type='_integer'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=ScanTable.NumCoh
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='NumInCoh'
	type='_integer'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=ScanTable.NumInCoh
	dat_new,name,type,ndim,dims
	cmp_put1i,name,values
;
	name='R0'
	type='_real'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.r0
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	name='PRES'
	type='_real'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.pres
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	name='RHUM'
	type='_real'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.rhum
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	name='TEMP'
	type='_real'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.temp
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	name='PWV'
	type='_real'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.pwv
	dat_new,name,type,ndim,dims
	cmp_put1r,name,values
;
	name='ZA'
	type='_double'
	ndim=1L
	dims[0]=n_elements(ScanTable)
	values=scans.za
	dat_new,name,type,ndim,dims
	cmp_put1d,name,values
;
	name='OutputBeam'
	type='EXTCOLUMN'
	ndim=1L
	dims[0]=GenConfig.NumOutBeam
	dat_new,name,type,ndim,dims
	dat_find,name
		vdim=1L
		for i=0L,GenConfig.NumOutBeam-1 do begin
			dat_cell,vdim,i+1
			type='_real'
			ndim=3L
			dims[0]=GenConfig.NumSpecChan[i]
			dims[1]=GenConfig.NumBaseline[i]
			dims[2]=n_elements(scans)
			name='VisSq'
			data=scans.VisSq[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='VisSqErr'
			data=scans.VisSqErr[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='VisSqC'
			data=scans.VisSqC[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='VisSqCErr'
			data=scans.VisSqCErr[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='VisPhase'
			data=scans.VisPhase[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='VisPhaseErr'
			data=scans.VisPhaseErr[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DiffPhase'
			data=scans.DiffPhase[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DiffPhaseErr'
			data=scans.DiffPhaseErr[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DiffPhaseC'
			data=scans.DiffPhaseC[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DiffPhaseCErr'
			data=scans.DiffPhaseCErr[i,0:dims[0]-1,0:dims[1]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DelayJitter'
			ndim=2L
			dims[0]=GenConfig.NumBaseline[i]
			dims[1]=n_elements(scans)
			data=scans.DelayJitter[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DelayJitterErr'
			ndim=2L
			dims[0]=GenConfig.NumBaseline[i]
			dims[1]=n_elements(scans)
			data=scans.DelayJitterErr[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DelayRMS'
			ndim=2L
			dims[0]=GenConfig.NumBaseline[i]
			dims[1]=n_elements(scans)
			data=scans.DelayRMS[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='DelayJitter2'
			ndim=2L
			dims[0]=GenConfig.NumBaseline[i]
			dims[1]=n_elements(scans)
			data=scans.DelayJitter2[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='PhotonRate'
			ndim=2L
			dims[0]=GenConfig.NumSpecChan[i]
			dims[1]=n_elements(scans)
			data=scans.PhotonRate[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='PhotonRateErr'
			data=scans.PhotonRateErr[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='BackGndRate'
			data=scans.BackGndRate[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='BackGndErr'
			data=scans.BackGndErr[i,0:dims[0]-1]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,data
;
			name='UVW'
			type='_double'
			ndim=3L
			dims[0]=GenConfig.NumBaseline[i]
			dims[1]=3
			dims[2]=n_elements(scans)
			data=scans.UVW[i,0,0:dims[0]-1,0:dims[1]-1] $
			    *GenConfig.Wavelength[0,i]
			dat_new,name,type,ndim,dims
			cmp_putnd,name,ndim,dims,data
;
			dat_annul
;
		endfor
		dat_annul
;
	if GenConfig.NumTriple gt 0 then begin
	name='Triple'
	type='EXTCOLUMN'
	ndim=1L
	dims[0]=GenConfig.NumTriple
	dat_new,name,type,ndim,dims
	dat_find,name
	  vdim=1L
	  for i=0L,GenConfig.NumTriple-1 do begin
	    dat_cell,vdim,i+1
	    type='_real'
	    ndim=3L
	    dims[0]=2
	    dims[1]=max(GenConfig.NumSpecChan)
	    dims[2]=n_elements(scans)
	    name='ComplTriple'
	    data=scans[0:dims[2]-1].ComplTriple(i,0:dims[0]-1,0:dims[1]-1)
	    dat_new,name,type,ndim,dims
	    cmp_putnr,name,ndim,dims,data
;
	    name='ComplTripleErr'
	    data=scans[0:dims[2]-1].ComplTripleErr(i,0:dims[0]-1,0:dims[1]-1)
	    dat_new,name,type,ndim,dims
	    cmp_putnr,name,ndim,dims,data
;
	    name='TripleAmp'
	    ndim=2L
	    dims[0]=max(GenConfig.NumSpecChan)
	    dims[1]=n_elements(scans)
	    data=scans[0:dims[1]-1].TripleAmp(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
	    cmp_putnr,name,ndim,dims,data
;
	    name='TripleAmpErr'
	    data=scans[0:dims[1]-1].TripleAmpErr(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    name='TriplePhase'
	    data=scans[0:dims[1]-1].TriplePhase(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    name='TriplePhaseErr'
	    data=scans[0:dims[1]-1].TriplePhaseErr(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    name='TripleAmpC'
	    ndim=2L
	    dims[0]=max(GenConfig.NumSpecChan)
	    dims[1]=n_elements(scans)
	    data=scans[0:dims[1]-1].TripleAmpC(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
	    cmp_putnr,name,ndim,dims,data
;
	    name='TripleAmpCErr'
	    data=scans[0:dims[1]-1].TripleAmpCErr(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    name='TriplePhaseC'
	    data=scans[0:dims[1]-1].TriplePhaseC(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    name='TriplePhaseCErr'
	    data=scans[0:dims[1]-1].TriplePhaseCErr(i,0:dims[0]-1)
	    dat_new,name,type,ndim,dims
            cmp_putnr,name,ndim,dims,data
;
	    dat_annul
          endfor
	  dat_annul
	endif
;
	name='InputBeam'
	type='EXTCOLUMN'
	ndim=1L
	dims[0]=GenConfig.NumSid
	dat_new,name,type,ndim,dims
	dat_find,name
		vdim=1L
		for i=0L,GenConfig.NumSid-1 do begin
			dat_cell,vdim,i+1
			name='FDLPos'
			type='_double'
			ndim=1L
			dims[0]=n_elements(scans)
			values=scans.FDLPos[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1d,name,values
;
			name='FDLPosErr'
			type='_real'
			values=scans.FDLPosErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='GrpDelay'
			type='_double'
			dat_new,name,type,ndim,dims
			values=scans.GrpDelay[i,*]
			cmp_put1d,name,values
;
			name='GrpDelayErr'
			type='_real'
			values=scans.GrpDelayErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='DryDelay'
			type='_double'
			values=scans.DryDelay[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1d,name,values
;
			name='DryDelayErr'
			type='_real'
			values=scans.DryDelayErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='WetDelay'
			type='_double'
			values=scans.WetDelay[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1d,name,values
;
			name='WetDelayErr'
			type='_real'
			values=scans.WetDelayErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParX'
			type='_real'
			values=scans.ParX[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParXErr'
			type='_real'
			values=scans.ParXErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParY'
			type='_real'
			values=scans.ParY[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParYErr'
			type='_real'
			values=scans.ParYErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParZ'
			type='_real'
			values=scans.ParZ[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='ParZErr'
			type='_real'
			values=scans.ParZErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='MetroDelay'
			type='_real'
			values=scans.MetroDelay[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='MetroDelayErr'
			type='_real'
			values=scans.MetroDelayErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='NATJitter'
			type='_real'
			values=scans.NATJitter[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='NATJitterErr'
			type='_real'
			values=scans.NATJitterErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='NATCounts'
			type='_real'
			values=scans.NATCounts[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			name='NATCountsErr'
			type='_real'
			values=scans.NATCountsErr[i,*]
			dat_new,name,type,ndim,dims
			cmp_put1r,name,values
;
			ndim=2L
			dims[0]=2
			dims[1]=n_elements(scans)
			name='NATJitter2'
			type='_real'
			values=scans.NATJitter2[i,*]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,values
;
;			VLTI/MIDI
			ndim=2L
			dims[0]=5
			dims[1]=n_elements(scans)
			name='AcqPSF'
			type='_real'
			values=scans.AcqPSF[i,*]
			dat_new,name,type,ndim,dims
			cmp_putnr,name,ndim,dims,values
;
			ndim=1L
			dims[0]=n_elements(scans)
			name='AcqFlux'
			values=scans.AcqFlux[i]
                        dat_new,name,type,ndim,dims
                        cmp_put1r,name,values
;
			ndim=3L
			dims[0]=genconfig.numoutbeam
			dims[1]=max(genconfig.numspecchan)
			dims[2]=n_elements(scans)
			name='Photometry'
			values=scans.Photometry[i,*,*]
                        dat_new,name,type,ndim,dims
                        cmp_putnr,name,ndim,dims,values
;
			name='PhotometryErr'
			values=scans.PhotometryErr[i,*,*]
                        dat_new,name,type,ndim,dims
                        cmp_putnr,name,ndim,dims,values
;
			name='PhotometryC'
			values=scans.PhotometryC[i,*,*]
                        dat_new,name,type,ndim,dims
                        cmp_putnr,name,ndim,dims,values
;
			name='PhotometryCErr'
			values=scans.PhotometryCErr[i,*,*]
                        dat_new,name,type,ndim,dims
                        cmp_putnr,name,ndim,dims,values
;
			dat_annul
		endfor
		dat_annul
;
toplevel
;
; Reinstate the deadtime corrected data
scans=scans_bck
;
end
