pro put_stationtable,table=table
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write StationCoord to file. Filename is derived from date of observation.
; Note that in the case of NPOI or VLTI, d is the total constant term value.
; In the case of VLTI, d is the OPL0. We also now write the delayline and
; beamcombiner input IDs, as these are important configuration information
; for the interpretation of the constant terms.
;
; If the table keyword is set, write the table, else write
; genconfig.stationcoord.
;
common Hds,path,hds_file_stub
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if checkdata([5,6,7]) ne 0 then return
;
if n_elements(table) eq 0 then table=1
;
; Set file name
if n_elements(hds_file_stub) eq 0 then file=''
if strlen(file) ne 0 then filename=hds_file_stub+'.stn' $
		     else filename=date+'.stn'
openw,unit,filename,/get_lun
;
RAD=180/pi_circle
stationid=genconfig.stationid
x=genconfig.stationcoord[0,*]
y=genconfig.stationcoord[1,*]
z=genconfig.stationcoord[2,*]
d=genconfig.stationcoord[3,*]
DL_ID=genconfig.delaylineid
BC_IN=genconfig.bcinputid
if table eq 1 then begin
	stationid=stationtable.stationid
	x=stationtable.x
	y=stationtable.y
	z=stationtable.z
	d=stationtable.d
	DL_ID=stationtable.DL_ID
	BC_IN=stationtable.BC_IN
endif
;
case system_id(systemid) of
	'Mark3':begin
		printf,unit,'! Mark3 station file. All units in m'
		printf,unit,'! Station    X[east]    Y[north]   Z[up]      D'
		end
	'NPOI' :begin
		printf,unit,'! NPOI CONFIGURATION'
		printf,unit,'!'
		printf,unit,'! Array center on Anderson Mesa'
		printf,unit,'! Latitutde = ',dms(GeoParms.Latitude)
		printf,unit,'! Longitude = ',dms(GeoParms.Longitude)
		printf,unit,'! Altitude = ',GeoParms.Altitude
		printf,unit,'!'
		printf,unit,'! Latitude, longitude and height are for the', $
		   	       ' nominal "array center", from'
		printf,unit,'! which the other positions are measured. X,', $
			       ' Y, Z form a right handed coord'
		printf,unit,'! system such that X = East Y = North and', $
			       ' Z = Up. All distances are in meters.'
		printf,unit,'!'
		printf,unit,'!        X           Y           Z           D (actual)'
		end
	'VLTI' :begin
		printf,unit,'! VLTI OPD model'
		if n_elements(stationid) eq 2 then begin
			printf,unit,'! VLTI-DL pointing error file'
			printf,unit,'!    1    1.0'
			at=genconfig.stationcoord[*,1] $
			  -genconfig.stationcoord[*,0]
			at=at*1d6
			printf,unit,'! A1L '+string(-at[3])+' 0.0'
			printf,unit,'! T1X '+string(at[0])+' 0.0'
			printf,unit,'! T1Y '+string(at[1])+' 0.0'
			printf,unit,'! T1Z '+string(-at[2])+' 0.0'
			printf,unit,'! END'
			printf,unit,'!        X [m],      Y [m],      Z [m],      OPL0 [m], delayline
		endif else begin
			printf,unit,'!        X [m],      Y [m],      Z [m],      Tel DL IC'
		endelse
		end
	   else:print,'***Error(PUT_STATIONTABLE): unknown system:', $
			systemid,'!'
endcase
for j=0,n_elements(stationid)-1 do printf,unit, $
	stationid[j],x[j],y[j],z[j],d[j],DL_ID[j],BC_IN[j], $
	format='(a,2x,4(1x,f11.6),2x,i1,2x,i1)'
free_lun,unit
print,'StationCoord written to: ',filename,'.'
;
end
