pro put_uvfits,stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Write averaged data from a single night into FITS multi-source file
; (single source file, i.e. no source table, if only one star is selected).
; New multi-IF version.
; Note that as in set_complexvis, it is assumed that the different
; spectrometers have identical channel layouts.
;
common Tables,ScanTable,BGTable,StationTable
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if checkdata([8,9]) ne 0 then return
;
; Determine star and scan indices
if n_elements(stars) eq 0 then stars=startable.starid
stars=strupcase(stars)
numstar=n_elements(stars)
star_mask=intarr(numstar)-1
scan_mask=intarr(n_elements(scans))-1
for k=0,numstar-1 do begin
	jndex=where(startable.starid eq stars[k],jcount)
	index=where(scans.starid eq stars[k],icount)
	if jcount gt 0 and icount gt 0 then begin
		star_mask[k]=jndex[0]
		scan_mask[index]=1
	endif else print,'Warning(PUT_UVFITS): no data for ',stars[k],'!'
endfor
scan_index=where(scan_mask ne -1,numscan)
if numscan eq 0 then begin
	print,'***Error(PUT_UVFITS): no valid scans found!'
	return
endif
star_index=star_mask[where(star_mask ge 0,numstar)]
if numstar eq 1 then filename=stars[0]+'.FITS' $
		else filename=date+'.FITS'
;
r=file_search(filename,count=fcount)
if fcount ne 0 then begin
	print,'***Error(PUT_OIFITS): file ',filename,' exists!'
	return
endif
;
; Header keywords (p.26 of FITS User's Guide)
parsedate,jd2date(systime(/julian)),y,m,d
DATE_NOW=aipsdate(y,m,d)		; DATE
parsedate,Date,y,m,d
DATE_OBS=aipsdate(y,m,d)		; DATE-OBS
JD=julian(y,m,d)-0.5
ORIGIN=getenv('HOST')			; ORIGIN
TELESCOP=systemid			; TELESCOP
if system_id(systemid) eq 'NPOI' then begin
OBSERVER='USNO/NRL/Lowell'		; OBSERVER
case genconfig.beamcombinerid of
	1: INSTRUME='3-way'
	2: INSTRUME='6-way'
     else: INSTRUME='3-way'
endcase
endif else if system_id(systemid) eq 'VLTI' then begin
OBSERVER='ESO SciOps'			; OBSERVER
case genconfig.beamcombinerid mod 10 of
	1: INSTRUME='VINCI'
	2: INSTRUME='MIDI'
        3: INSTRUME='AMBER'
endcase
endif else begin
	OBSERVER='OBSERVER'
	INSTRUME='INSTRUMENT'
endelse
AUTHOR=getenv('USER')			; AUTHOR
;
; Dimensioning information
numsid=GenConfig.NumSid
numoutbeam=GenConfig.NumOutBeam
numchannel=GenConfig.NumSpecChan
numbaseline=GenConfig.NumBaseline
maxchannel=max(GenConfig.NumSpecChan)
maxbaseline=max(GenConfig.NumBaseline)
;
; Number of random groups (gcount)
numvis=long(numscan*summe(numbaseline[0:numoutbeam-1]))
;
; Visibility data
real_vis=double(scans[scan_index].complexvis)
imag_vis=double(imaginary(scans[scan_index].complexvis))
weight=double(scans[scan_index].complexweight)
;
; Random parameter data (pcount parameters per random group)
; U V W
uvw=scans[scan_index].uvw
; Baseline (= 256*i + j for antennas i < j)
fbase=dblarr(maxbaseline,numoutbeam)
for i=0,numoutbeam-1 do begin
for l=0,numbaseline[i]-1 do begin
	m=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[l,i],0,3))+1
	n=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[l,i],4,3))+1
	if m gt n then begin
		n0=n
		m0=m
		n=m0
		m=n0
		imag_vis[i,*,l,*]=-imag_vis[i,*,l,*]
		uvw[i,*,l,*,*]=-uvw[i,*,l,*,*]
	endif
	fbase[l,i]=256*m+n
endfor
endfor
; Date offset
time=abs(scans[scan_index].time/86400)
; Source ID
source_id=lonarr(numscan)
for i=0,numstar-1 do source_id[where(scans[scan_index].starid $
		                  eq startable[star_index[i]].starid)]=i
;
; Data for Source FITS table
SOURCE=startable[star_index].starid
RAEPP=startable[star_index].ra*15
DECEPP=startable[star_index].dec
;
; Data for Frequency FITS table
iffreq0=c_light/genconfig.wavelength[0,0]
iffreqs=c_light/genconfig.wavelength[0:maxchannel-1,0:numoutbeam-1]-iffreq0
chwidth=c_light/genconfig.wavelength[0:maxchannel-1,0:numoutbeam-1]^2 $
               *genconfig.chanwidth[0:maxchannel-1,0:numoutbeam-1]
chwidth=float(chwidth)
;
; Keywords for Antenna table
RAD=180/pi_circle
gstia0=ut12gst(0)*15.d0
ut1utc=geoparms.ut1utc_coeffs[0]
datutc=geoparms.tai_utc
r_earth=6378.136d3
arrayc=(r_earth+geoparms.altitude)* $
	[cos(geoparms.latitude/RAD)*cos(geoparms.longitude/RAD), $
	 cos(geoparms.latitude/RAD)*sin(geoparms.longitude/RAD), $
	 sin(geoparms.latitude/RAD)]
;
; Data for Array Geometry FITS table (antenna table)
stations=strarr(numsid)
stncoord=dblarr(3,numsid)
for i=0,numsid-1 do begin
;	Bring into equatorial system
	npoi_x=GenConfig.StationCoord[0,i]
	npoi_y=GenConfig.StationCoord[1,i]
	npoi_z=GenConfig.StationCoord[2,i]
	x=cos(GeoParms.Latitude/RAD)*npoi_z-sin(GeoParms.Latitude/RAD)*npoi_y
	y=npoi_x
	z=cos(GeoParms.Latitude/RAD)*npoi_y+sin(GeoParms.Latitude/RAD)*npoi_z
	stncoord[*,i]=[x,y,z]
	stations[i]=genconfig.stationid[i]
endfor
;
; Call FITS writer
status=linknload(!external_lib,'writefits', $
	JD,DATE_NOW,DATE_OBS,ORIGIN,TELESCOP,INSTRUME,OBSERVER,AUTHOR,SOURCE, $
	RAEPP,DECEPP, $
	gstia0,ut1utc,datutc, $
	iffreq0,iffreqs,chwidth, $
	numvis,numscan,numsid,numoutbeam,numchannel,numbaseline, $
	maxchannel,maxbaseline, $
	time,uvw,real_vis,imag_vis,weight,fbase,stations,stncoord,arrayc, $
	source_id,numstar)
;
end
