pro put_wds,starid,datarequest=wdsfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; If starid is specified, determine its WDS name and lookup in WDS data base.
; Retrieve the data using B. Mason's datarequest procedure, and save to disk.
;
; starid must be CCCNNNN/CCCNNNNNN or hhmmf+ddmm.
;
; If we have the data file from USNO, pass it as wdsfile.
;
common StarBase,startable,notes
;
rad=180/!pi
;
; If we got the file from USNO, go directly to DATAREQUEST
if n_elements(wdsfile) ne 0 then begin
	f=file_search(wdsfile)
	if n_elements(f) gt 1 then f='' else f=f[0]
	if strlen(f) eq 0 then begin
		printf,'File not found.'
		return
	endif
	words=nameparse(f,'.')
	wdspos=words[0]
	comp=''
	cmpidx=0
	goto,DATAREQUEST
endif
;
if n_elements(starid) eq 0 then begin
	starid=''
	if n_elements(startable) eq 1 then starid=startable.starid
endif
if n_elements(startable) eq 0 then begin
	if valid_cat[starid] then get_startable,starid
endif
;
count=0
starid=strupcase(starid[0])
if n_elements(startable) ne 0 then i=where(startable.starid eq starid,count)
if count gt 1 then print,'Warning(PLOT_WDS): more than one star!'
if count eq 1 then begin
;	Found the star in startable
	i=i[0]
	ra=startable[i].ra
	dec=startable[i].dec
	name=hms(ra,/wds)+dms(dec,/wds)
;
	if 0 then begin
; 	Obtain search string from (J2000.0) coordinates
; 	RA:
	rah=fix(ra)
	ram=string(fix((ra mod 1)*60),format='(i2.2)')
;	if ram eq '60' then begin
;		ram='00'
;		rah=rah+1
;	endif
	ras=string(rah,format='(i2.2)')+ram
	ras=hms(ra,/wds)
;
; 	DEC:
	decd=abs(fix(dec))
	decm1=string(nint(abs(dec mod 1)*60),format='(i2.2)')
	decm2=string(fix(abs(dec mod 1)*60),format='(i2.2)')
;	if decm eq '60' then begin
;		decm='00'
;		if dec ge 0 then decd=decd+1 else decd=decd-1
;	endif
	decs1=string(decd,format='(i3.2)')+decm1
	decs2=string(decd,format='(i3.2)')+decm2
;	This code added Sep 16, 2015
	if dec gt 0 then strput,decs1,'+' else strput,decs1,'-'
	if dec gt 0 then strput,decs2,'+' else strput,decs2,'-'
	endif
endif else begin
;	...or the star might be of form 'WDS+hhmmfddmm' or 'hhmmf+ddmm'
	if strlen(starid) ne 10 and strlen(starid) ne 13 then begin
		print,'Star ID not the right format!'
		print,'Must be: hhmmf+ddmm or WDS+hhmmfddmm.'
		return
	endif
	name=starid
	if strmid(starid,0,3) eq 'WDS' then $
	name=strmid(starid,4,5)+strmid(starid,3,1)+strmid(starid,9,4)
;	ra=float(strmid(name,0,2))+float(strmid(name,2,2))/60 $
;				  +float(strmid(name,4,1))/600
;	dec=float(strmid(name,6,2))+float(strmid(name,8,2))/60
;	if fix(strmid(name,5,5)) lt 0 then dec=-dec
;	name=name
;
;	if strlen(starid) eq 10 then pos=starid
;	if strlen(starid) eq 13 then pos=strmid(starid,4,5) $
;					+strmid(starid,3,1) $
;					+strmid(starid,9,4)
;	ras=strmid(pos,0,4)
;	decs1=strmid(pos,6,4)
;	decs2=decs1
endelse
;
; Check for the entry in the bible (outdated, see file "update")
; wget http://ad.usno.navy.mil/wds/Webtextfiles/wdsweb_summ2.txt
; wget http://ad.usno.navy.mil/wds/Webtextfiles/wdsnewnotes_main.txt
; wget http://ad.usno.navy.mil/wds/Webtextfiles/wdsnewref.txt
; wget http://ad.usno.navy.mil/wds/orb6/orb6orbits.txt
; wget http://ad.usno.navy.mil/wds/orb6/orb6ephem.txt
print,'hhmmf ddmmDSCNNNNComp  YYYY YYYY   #O PAf PAl Sep_f Sep_l Mag_A Mag_B Spe
wds_bible=' '+!catalogs_dir+'wds/wdsnewframe.txt'
wds_bible=' '+!catalogs_dir+'wds/wdsweb_summ.txt'
; This code commented (4 lines) Sep 16, 2015
; wds_bible=' '+!catalogs_dir+'wds/wdsids_summ.txt'
; spawn,'grep '+ras+wds_bible+' | grep '+decs1,entries
; if strlen(strcompress(entries(0),/remove_all)) eq 0 then $
; spawn,'grep '+ras+wds_bible+' | grep '+decs2,entries
; This code replaces the prvious 4 lines
; spawn,'grep '+ras+decs1+wds_bible,entries
; if strlen(strcompress(entries(0),/remove_all)) eq 0 then  $
; spawn,'grep '+ras+decs2+wds_bible,entries
;
spawn,'grep '+name+wds_bible,entries
if strlen(strcompress(entries[0],/remove_all)) eq 0 then begin
	print,'Star not found! Please check coordinates!'
	return
endif
; index=where(strpos(entries,ras) eq 0)
index=where(strpos(entries,name) eq 0)
entries=entries[index]
for i=0,n_elements(entries)-1 do print,strmid(entries[i],0,78)
;
; Retrieve WDS data locally, else ask to submit request form
path=''
path=!catalogs_dir
if strlen(path) eq 0 or total(strlen(file_search(path))) eq 0 then begin
   print,'Warning(PLOT_WDS): cannot access WDS, please submit data request to:'
   print,'                    http://ad.usno.navy.mil/ad/wds/wds_request.html'
   return
endif
comp=''
read,'Component to select (hit RETURN to quit, SPACE for blank component): ',com
if strlen(comp) eq 0 then return
comps=strmid(entries,17,5)
index=where(strpos(comps,comp) ne -1,count)
comps=strcompress(comps,/remove_all)
if total(strlen(comps)) eq 0 then comps=comp
index=where(comps eq comp,count)
if count eq 0 then begin
	print,'***Error(PLOT_WDS): component not found!'
	return
endif
entry=strmid(entries[index[0]],0,17)
pos=strmid(entry,0,10)
;
; As of 2012, we use the sequence number to identify the selected data
; cmpidx=where(strpos(entries,comp) ge 0)
; cmpidx=cmpidx(0)
;
; Submit request
infile='datarequest.in'
openw,unit,infile,/get_lun
printf,unit,pos
free_lun,unit
spawn,!catalogs_dir+'wds/datarequest'
spawn,'rm -f '+infile
wdspos='wds'+pos
;
; Read the extracted data
DATAREQUEST:
data=''
status=dc_read_fixed(wdspos+'.txt',data,/col,resize=[1],format='(a120)')
if status ne 0 then return
;
; Locate the section which lists the observations, cmpidx locates by sequence #
index=where(strpos(data,'MEASURES') ne -1)
; added code 2015...
jndex=where(strpos(data,'--------') ne -1)
ipos1=index[0]+2
ipos2=jndex[where(jndex gt index[0])] & ipos2=ipos2[0]-1
cmpidx=where(strlen(strtrim(data[ipos1:ipos2])) eq strlen(strtrim(data[ipos1])))
if strlen(comp) eq 0 then cmpsel=indgen(n_elements(cmpidx)) else $
cmpsel=where(strtrim(strmid(data[cmpidx+ipos1],7,5)) eq comp)
ipos1=cmpidx[cmpsel]+ipos1+1
; ipos1=index(cmpidx)+3
; ...end of update
ipos2=ipos1
while strlen(strcompress(data[ipos2],/remove_all)) ne 0 do ipos2=ipos2+1
data=data[ipos1:ipos2-1]
;
; Extract data for this component
; The following line with formats copied from datarequest.pro for reference
; printf,3,datlin,newref,aper,meth,code1,code2,format='(a40,3x,a8,3x,a3,8x,a1,7x
;
num_obs=n_elements(data)
pa=fltarr(num_obs)
pae=fltarr(num_obs)
sep=fltarr(num_obs)
sepe=fltarr(num_obs)
epa=fltarr(num_obs)
emaj=fltarr(num_obs)+5
emin=fltarr(num_obs)+5
date=dblarr(num_obs)
for i=0,num_obs-1 do begin
	date[i]=float(strmid(data[i],7,8))
	pa_string=strmid(data[i],19,5)
	sep_string=strmid(data[i],37,6)
	if isnumeric(pa_string) and $
	   isnumeric(sep_string) then begin
		pa[i]=float(pa_string)
		sep[i]=float(sep_string)*1000
		pae_string=strmid(data[i],28,3)
		sepe_string=strmid(data[i],46,6)
		if isnumeric(pae_string) and $
		   isnumeric(sepe_string) then begin
			pae[i]=float(pae_string)/180*!pi
			sepe[i]=float(sepe_string)*1000
			if sin(pae[i])*sep[i] gt sepe[i] then begin
				epa[i]=(pa[i]+90) mod 180
				emin[i]=sepe[i]
				emaj[i]=sin(pae[i])*sep[i]
			endif else begin
				epa[i]=pa[i]
				emaj[i]=sepe[i]
				emin[i]=sin(pae[i])*sep[i]
			endelse
		endif
	endif
;	sep_unit_code=strmid(data(i),73,1)
;	if sep_unit_code eq 'A' then sep(i)=sep(i)/1000
endfor
;
index=where(sep gt 0,count)
if count eq 0 then return
pa=pa[index]
sep=sep[index]
epa=epa[index]
emaj=emaj[index]
emin=emin[index]
date=date[index]
year=jd2jy(by2jd(date))
pap=precess_pa(pa/rad,year,ra,dec,1)
;
; Write data in AMOEBA format
filename=wdspos+'.psn'
openw,unit,filename,/get_lun
print,'Opened file for output: ',filename
num_obs=n_elements(date)
bin_comp='A-B'
for i=0,num_obs-1 do begin
	       printf,unit,bin_comp,year[i],sep[i],pa[i], $
				emaj[i],emin[i],epa[i], $
 		format='(a,2x,f9.4,3x,f7.1,2x,f6.1,2x,f7.1,1x,f7.1,1x,f6.1)'
endfor
;
free_lun,unit
;
; Remove useless pngfiles file
command='rm -f '+wdspos+'.pngfiles'
if safe(command) then spawn,command
;
end
