pro quack,point=point
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For raw data (default), detect (first) gap larger than 50 s and flag data
; before or beyond gap depending on which section is smaller.
; For loaded pointdata, flag the last point in each scan.
;
common LocalQuack,i1,i2
common Tables,ScanTable,BGTable,StationTable
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
        Raw0,RawN,OutputBeam,BinCounts
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
; if checkdata([1,8,11]) ne 0 then return
;
if n_elements(point) eq 0 then point=0
;
IF not point THEN BEGIN
;
	t=timestamp/1000. & t=t-t[0]
	n=n_elements(t)
	i=where(t[1:n-1]-t[0:n-2] gt 50,count)
	if count gt 0 then begin
		i=i[0] ; Just do first gap
		if i gt n/2 then begin
			i1=0
			i2=i
		endif else begin
			i1=i+1
			i2=n-1
		endelse
		timestamp=timestamp[i1:i2]
		laserpos=laserpos[*,i1:i2]
		geopos=geopos[*,i1:i2]
		quadcounts=quadcounts[*,*,i1:i2]
		if n_elements(bincounts) ne 0 and RawN gt 0 then begin
			if rawn+1 eq n_elements(bincounts[0,0,*]) then begin
				bincounts=bincounts[*,*,i1:i2]
				rawn=i2-i1
			endif
		endif
	endif
	i=n_elements(timestamp)
	if n_elements(bincounts) ne 0 then begin
		if n_elements(bincounts[0,0,*]) gt i then begin
			bincounts=bincounts[*,*,i1:i2]
			rawn=i2-i1
		endif
	endif
;
ENDIF ELSE BEGIN
;
	if n_elements(Rec0) eq 0 then return
;
	NS=n_elements(RecN)
;
	if n_elements(pointflagtable) eq 0 then create_pointflagtable
	index=where(pointflagtable.time ge 0,count)
	id0=count
;
	timestamp=systime()
	reason=timestamp+' '+'QUACK'
;
	item=lonarr(NS)+1
	inbeam=lonarr(NS)
	outbeam=lonarr(NS)
	triple=lonarr(NS)
	chan=lonarr(NS)
	base=lonarr(NS)
	time=abs(PointTime[RecN])
	set_pointflagtable,reason,item,inbeam,outbeam,triple,chan,base,time
	flagpointdata,pointflagtable[id0:id0+NS-1],flag=1
;
ENDELSE
;
print,'Quack completed.'
;
end
