function quasol,c
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the two solutions of the quadratic equation c+bx+ax^2=0, where
; [c,b,a]=c[0:2].
;
; Example: 18 - 15x + 3x^2
; print,quasol([18.,-15.,3.])
; Solutions: x = 3.0 and x = 2.0
;
arg=c[1]^2-4*c[2]*c[0]
index=where(arg lt 0,count)
if count ge 1 then arg[index]=0
d=sqrt(arg)
s1=(-c[1]+d)/(2*c[2])
s2=(-c[1]-d)/(2*c[2])
if count ge 1 then begin
	s1[index]=0
	s2[index]=0
endif
;
return,[s1,s2]
;
end
