function rad_mass,mass
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use mass-radius relationship for main-sequence stars to predict
; effective radius (solar) from mass. Input data from Torres et al. 2010
;
; Radius in solar units.
;
; New version using data from Torres et al. 2010
status=dc_read_free(!oyster_dir+'starbase/torres.dat', $
	m,em,rad,erad,teff,eteff,logg,elogg,logl,elogl,mv,emv, $
	/col,ignore=['!'])
; Exclude slightly evolved stars with log(g) < 4.3/4.1 for mass <10/>10
index=where((m le 10 and logg gt 4.3) or (m gt 10 and logg gt 4.1))
r=poly_fit(alog10(m[index]),rad[index],4,yfit)
if n_elements(mass) eq 0 then begin
	plot,alog10(m),rad,psym=1,title='Data from Torres et al. 2010', $
		xtitle='log(mass)',ytitle='Radius',charsize=1.5
	oplot,alog10(m[index]),rad[index],psym=1,color=tci(3)
	oplot,alog10(m[index]),yfit,psym=0,color=tci(3)
;	Overplot numerical relation from Allen's A. Q., p. 382
	lm=findgen(100)/50-0.5
	lr=fltarr(100)
	index=where(lm gt 0.12)
	lr[index]=0.640*lm[index]+0.011
	index=where(lm le 0.12)
	lr[index]=0.917*lm[index]-0.020
	oplot,lm,10^lr,psym=0,color=tci(1)
	return,0
endif else $
return,poly(alog10(mass),r)
;
end
