function rad_rsun,r_sol,d_pc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute stellar radius in mas from input in solar units and distance in pc.
; 1 pc = 206266.3 AU; the diameter of the Sun is about 0.01 AU.
; 1 pc = distance where 1 AU appears under an angle of 1".
;
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
RAD=180.d0/!pi
;
; Convert r_sol to AU
r_au=r_sol*r_sun/a_unit
;
; Convert r_au to pc (Jean Meeus, Astronomical Algorithms, p.366)
r_pc=r_au/206265.d0
;
; Convert r_sol[pc] at distance d_pc to angle in mas
r_mas=(atan(r_pc/d_pc)*RAD)*3600.d0*1000.d0
;
return,r_mas
;
end
