function rad_teff,teff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return main-sequence radius computed as a function of effective temperature.
; Based on Boyajian et al. 2017 (erratum), equation 8 valid for 3200 < T < 5500
; and equation 9 for more massive stars. Solar units.
;
t=float(teff)
;
index=where(t lt 3200,count)
if count gt 0 then print,'Warning: this function only valid for 3200 < T'
;
r=teff
;
index=where(t ge 3200 and t le 5500,count)
if count gt 0 then r[index]=-8.133+5.09342e-3*t-9.86602e-7*t^2+6.47963e-11*t^3
;
index=where(t gt 5500,count)
if count gt 0 then r[index]=-10.8828+7.18727e-3*t-1.50957e-6*t^2+1.07572e-10*t^3
;
return,r
;
end
