function rad_vsini,vsini,i,period
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute stellar radius in solar units from v*sin(i), i, and period
; vsini [km/s], incl [deg], period [d]
;
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
rad=180/!pi
p=period*86400/(2*!pi)
;
return,(vsini/sin(i/rad))*(p/(r_sun/1000))
;
end
