function radius_dwarf,spectrum
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute stellar radius using the log(M)-log(R) diagram,
; based on Torres et al. 2010
;
; Measured coordinates
coords=[ $
[187,375], [209,359], [225,351], [245,340], [293,310], [328,290], [341,285], $
[350,282], [359,281], [362,277], [373,267], [380,261], [394,245], [413,234], $
[432,214], [437,208], [473,182]]
coords_refp=[[178,133], [519,387]]
coords_refd=[[1.5,-1.0], [-1.0,1.0]]
scale_m=(coords_refp[*,1]-coords_refp[*,0]) $
       /(coords_refd[*,1]-coords_refd[*,0])
n=17
lmass=fltarr(n)
lradi=fltarr(n)
for i=0,n-1 do begin
	lmass[i]=(coords[0,i]-coords_refp[0,0])/scale_m[0]+coords_refd[0,0]
	lradi[i]=(coords[1,i]-coords_refp[1,0])/scale_m[1]+coords_refd[1,0]
endfor
;
spec_parse,spectrum,type,class,type2,class2
lmasses=alog10(mass_dwarf[type])
return,10^interpol(lradi,lmass,lmasses)
;
end
