pro rawlist,date
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Collect and analyse all raw files corresponding to date, write binary
; packet directories and parameter files for use with CONSTRICTOR.
;
if n_elements(date) eq 0 then begin
	jd=systime(/julian)
	caldat,systime(/julian),m,d,y
	date=constrictordate(y,m,d)
endif
;
parsedate,date,y,m,d
rdate=rawdate(y,m,d)
; Need to check for files from previous UT day
yesterday=previousdate(date)
parsedate,yesterday,yy,my,dy
ydate=rawdate(yy,my,dy)
jd=julian(y,m,d)
doy=fix(jd-julian(y,1,1))+1
;
rawdir=''
if strupcase(getenv('HOST')) eq 'OCTANS'  then rawdir='/datacon11/'
;
rawfiles=file_search(rawdir+rdate+'*')
yesterdayFiles=findfile(rawdir+ydate+'*')
if strlen(rawfiles[0]) eq 0 then begin
	print,'***Error(RAWLIST): no files found for this date!'
	return
endif
; concatenate files with today's date and previous date
; if required
if yesterdayFiles[0] ne '' then rawfiles=[yesterdayFiles,rawfiles]
index=where(strpos(rawfiles,'starLog') ge 0,count)
if count eq 1 then scnfile=rawfiles[index[0]] else scnfile=''
index=where(strpos(rawfiles,'log') ge 0,count)
if count eq 1 then obsfile=rawfiles[index[0]] else obsfile=''
;
index=where(strpos(rawfiles,'.gz') eq -1,numfiles)
if numfiles eq 0 then begin
	print,'***Error(RAWLIST): all files have .gz extension!'
	return
endif
rawfiles0=rawfiles[index]
;
i0=0
index=where(strpos(rawfiles0,'fringeData') ge 0,count)
if count gt 0 then rawfiles[i0:i0+count-1]=rawfiles0[index]
i0=i0+count
index=where(strpos(rawfiles0,'alignData') ge 0,count)
if count gt 0 then rawfiles[i0:i0+count-1]=rawfiles0[index]
i0=i0+count
index=where(strpos(rawfiles0,'sidData') ge 0,count)
if count gt 0 then rawfiles[i0:i0+count-1]=rawfiles0[index]
i0=i0+count
numfiles=i0
rawfiles=rawfiles[0:numfiles-1]
;
infiles=strarr(numfiles)
dirfiles=strarr(numfiles)
maxpacket=intarr(numfiles)
j=0
;
print,'Begin processing raw files...'
for i=0,numfiles-1 do begin
;	Get packet directory
	d=packetdir(rawfiles[i])
	n=n_elements(d)
;	Write packet list file
	openw,unit,date+'.'+strcompress(string(i+1),/remove)+'.lst',/get_lun
	for k=0l,n-1 do printf,unit,d[k].length,d[k].time,d[k].day,' ', $
		hms(double(d[k].time)/3600000l),packettype(d[k].type)
	free_lun,unit
;	Read all packets and update header time stamps from time stamps in body
	!qiet=1
	if jd ge julian(2001,9,25) then begin
		ht=d.time
		for k=0l,n-1 do begin
			p=readpacket(d[k])
			d[k].time=p.header.time
		endfor
		index=where(strpos(packettype(d.type),'SCAN_START') ge 0,count)
		for k=0,count-1 do begin
			kndex=where((strpos(packettype(d.type),'FRINGE_DATA') ge 0 $
				  or strpos(packettype(d.type),'FRINGE_BG') ge 0) $
				 and d.time lt d[index[k]].time)
			if kndex[0] ge 0 then begin
				d[where(d.time eq max(d[kndex].time))].time=0
			endif
		endfor
	endif
	d=d[where(d.time gt 0)]
	n=n_elements(d)
	print,rawfiles[i],': ',n,' valid packets'
	!qiet=0
;	Write binary packet directory
	openw,unit,date+'.'+strcompress(string(i+1),/remove)+'.dir',/get_lun
	for k=0l,n-1 do begin
		writeu,unit,long(i)
		writeu,unit,d[k].type
		writeu,unit,ulong(d[k].offset)
		writeu,unit,d[k].day
		writeu,unit,d[k].time
	endfor
	free_lun,unit
;	Check END_OF_DISK
	if packettype(d[n-1].type) ne 'END_OF_DISK' then begin
		print,'! No END_OF_DISK packet'
	endif
;	Check day numbers
	if n_elements(unique(d.day)) gt 1 then begin
		print,'! Several day numbers: ',unique(d.day)
	endif
	index=where(d.day ne doy,count)
	if count gt 0 then begin
		print,'! Unexpected day numbers: ',unique(d[index].day)
	endif
;
	infiles[j]=rawfiles[i]
	dirfiles[j]=date+'.'+strcompress(string(i+1),/remove)+'.dir'
	maxpacket[j]=n
	j=j+1
endfor
;
if j gt 0 then begin
	filestring=strjoin('"'+rawfiles[0:j-1]+'",')
	filestring=strmid(filestring,0,strlen(filestring)-1)
	dirstring=strjoin('"'+dirfiles[0:j-1]+'",')
	dirstring=strmid(dirstring,0,strlen(dirstring)-1)
	maxstring=strjoin(string(maxpacket)+',')
	maxstring=strmid(maxstring,0,strlen(maxstring)-1)
	openw,unit,date+'.par',/get_lun
	printf,unit,'InFiles = '+filestring
	printf,unit,'DirFiles = '+dirstring
	printf,unit,'MaxPacket ='+maxstring
	printf,unit,'DayNumber = '+string(doy)
	printf,unit,'StartTime = "00:00:00"'
	printf,unit,'StopTime = "24:00:00"'
	printf,unit,'LogFile = '+obsfile
	printf,unit,'ScnFile = '+scnfile
	printf,unit,'OutFile = '+date+'.con'
	printf,unit,'Raw = Off'
	printf,unit,'Lock = Off'
	printf,unit,'Triple = On'
	printf,unit,'NumAv = 500'
	printf,unit,'RefStation = 4'
	printf,unit,'SmartFDLAverage = Off'
	printf,unit,'Metrology = Off'
	printf,unit,'Nat = On'
	free_lun,unit
endif
;
end
