pro read_catalogs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read catalogs according to star names.
; Implemented catalogs:
; BSC Bright Star Catalogue, Hoffleit & Jaschek 1982
; HIC HIPPARCOS Input Catalogue
; HIP HIPPARCOS Output Catalogue
; HDN Sky Catalogue 2000 (redirected to HIP due to copyright)
; SAO Catalogue
; FKV Fundamental Katalog Nr. 5
; BAT Eighth Catalogue of the orbital elements of spectroscopic binary systems
; FLN A Finding List for Observers of Interacting Binary Stars, 5th Edition
; WDS Washington Double Star Catalog (read with get_wds,stars)
;
common StarBase,StarTable,Notes
;
numstars=n_elements(StarTable)
;
starid=StarTable.starid
name=strarr(numstars)
for i=0L,numstars-1 do begin
	starname='                    '
	strput,starname,StarTable[i].name
	name[i]=starname
endfor
var=strarr(numstars)
for i=0L,numstars-1 do begin
	starname='          '
	strput,starname,StarTable[i].var
	var[i]=starname
endfor
;
; Redirect HDN to HIP if SkyCat not available
hdn_count=0
if getenv('USER') ne !owner then begin
	hdn_index=where(strmid(startable.starid,0,3) eq 'HDN',hdn_count)
	if hdn_count gt 0 then begin
		print,'Redirecting HDN to HIP...'
		hdn_starids=startable[hdn_index].starid
		hdn_ids=long(strmid(hdn_starids,3,6))
		hip=cri(hdn_ids,'hdn-hic') > 0
		startable[hdn_index].starid='HIP'+stringl(hip,format='(i6.6)')
		starid[hdn_index]=startable[hdn_index].starid
	endif
endif
;
ra=StarTable.ra
dec=StarTable.dec
bat=StarTable.bat
hdn=StarTable.hdn
bsc=StarTable.bsc
fkv=StarTable.fkv
hic=StarTable.hic
sao=StarTable.sao
fln=StarTable.fln
ads=StarTable.ads
mv=StarTable.mv
bv=StarTable.bv
ub=StarTable.ub
ri=StarTable.ri
dmv=StarTable.dmv
pmra=StarTable.pmra
pmdec=StarTable.pmdec
rv=StarTable.rv
vsini=StarTable.vsini
px=StarTable.px
pxe=StarTable.pxe
spectrum=StarTable.spectrum & spectrum[*]='                              '
type=StarTable.type
type2=StarTable.type2
class=StarTable.class
class2=StarTable.class2
a=StarTable.a
p=StarTable.p
t=StarTable.t
o=StarTable.o
e=StarTable.e
k1=StarTable.k1
k2=StarTable.k2
mf=StarTable.mf
m1sin3i=StarTable.m1sin3i
m2sin3i=StarTable.m2sin3i
a1sini=StarTable.a1sini
a2sini=StarTable.a2sini
hflag=StarTable.hflag
vflag=StarTable.vflag
;
name_b=byte(name) & name_b_num=n_elements(name_b[*,0])
var_b=byte(var) & var_b_num=n_elements(var_b[*,0])
spectrum_b=byte(spectrum) & spectrum_b_num=n_elements(spectrum_b[*,0])
hflag_b=byte(hflag) & hflag_b_num=n_elements(hflag_b[*,0])
vflag_b=byte(vflag) & vflag_b_num=n_elements(vflag_b[*,0])
;
status=linknload(!external_lib,'catalog',numstars,starid,name,var,ra,dec, $
	bat,hdn,bsc,fkv,hic,sao,fln,ads, $
	mv,bv,ub,ri,dmv,pmra,pmdec,rv,vsini,px,pxe, $
	spectrum,type,type2,class,class2, $
	p,t,o,e,k1,k2,mf,m1sin3i,m2sin3i,a1sini,a2sini,a,hflag,vflag, $
	name_b,var_b,spectrum_b,hflag_b,vflag_b, $
	name_b_num,var_b_num,spectrum_b_num,hflag_b_num,vflag_b_num)
if status ne 0 then begin
	print,'***Error(READ_CATALOGS): error reading catalogs!'
	return
endif
;
if numstars eq 1 then begin
	name=name[0]
	var=var[0]
	spectrum=spectrum[0]
endif
;
StarTable.starid=starid
StarTable.name=strtrim(name,0)
StarTable.var=var
StarTable.ra=ra
StarTable.dec=dec
StarTable.bat=bat
StarTable.hdn=hdn
StarTable.bsc=bsc
StarTable.fkv=fkv
StarTable.hic=hic
StarTable.sao=sao
StarTable.fln=fln
StarTable.ads=ads
StarTable.mv=mv
StarTable.bv=bv
StarTable.ub=ub
StarTable.ri=ri
StarTable.dmv=dmv
StarTable.pmra=pmra
StarTable.pmdec=pmdec
StarTable.rv=rv
StarTable.vsini=vsini
StarTable.px=px
StarTable.pxe=pxe
StarTable.spectrum=strcompress(spectrum,/remove_all)
StarTable.type=type
StarTable.type2=type2
StarTable.class=class
StarTable.class2=class2
StarTable.a=a
StarTable.p=p
StarTable.t=t
StarTable.o=o
StarTable.e=e
StarTable.k1=k1
StarTable.k2=k2
StarTable.mf=mf
StarTable.m1sin3i=m1sin3i
StarTable.m2sin3i=m2sin3i
StarTable.a1sini=a1sini
StarTable.a2sini=a2sini
StarTable.hflag=strtrim(hflag)
StarTable.vflag=strtrim(vflag)
;
StarTable.name=strtrim(string(name_b),0)
StarTable.var=string(var_b)
StarTable.spectrum=strcompress(string(spectrum_b),/remove_all)
StarTable.hflag=strtrim(string(hflag_b))
StarTable.vflag=strtrim(string(vflag_b))
;
; If HDN was redirected to HIP, restore original star ID
if hdn_count gt 0 then begin
	startable[hdn_index].starid=hdn_starids
	startable[hdn_index].hdn=hdn_ids
endif
;
; Non-standard star lists
; Look here first as we use cri_vlti
index=where(strmid(startable.starid,0,3) eq 'OBJ',count)
if count gt 0 then begin
;	Stars without known catalog ID
	radec=esopos(strmid(startable[index].starid,3,16))
	startable[index].ra=radec[*,0]
	startable[index].dec=radec[*,1]
	for i=0,n_elements(index)-1 do $
		startable[index[i]].starid=cri_vlti(startable[index[i]].starid, $
		startable[index[i]].ra,startable[index[i]].dec)
endif
index=where(strmid(startable.starid,0,3) eq 'WDS',count)
if count gt 0 then begin
;	WDS stars
	n=0l
	table=startable
	get_wds,table[index].starid
	for i=0L,n_elements(startable)-1 do begin
		index=where(table.starid eq startable[i].starid,l)
		if l gt 0 then begin
		n=n+1
		for j=0,n_tags(startable[i])-1 do $
			table[index].(j)=startable[i].(j)
		endif
	endfor
	print,'Entries found in WDS.xdr: ',n
	startable=table
endif
index=where(strmid(startable.starid,0,3) eq 'USR',count)
if count gt 0 then begin
;	USR stars
	n=0l
	table=startable
	table_tags=tag_names(table)
	get_cat,'USR'
	startable_tags=tag_names(startable)
	for i=0L,n_elements(startable)-1 do begin
		jndex=where(long(strmid(table[index].starid,3,6)) $
			 eq long(strmid(startable[i].starid,3,6)),l)
		if l gt 0 then begin
		n=n+1
		for j=0,n_tags(startable[i])-1 do begin
			k=where(table_tags eq startable_tags[j],l)
			if l eq 1 then table[index[jndex]].(k)=startable[i].(j)
		endfor
		endif
	endfor
	print,'Entries found in USR.xdr: ',n
	startable=table
endif
index=where(strmid(startable.starid,0,3) eq 'HDN' and startable.hdn eq 0,count)
if count gt 0 then begin
;	Get info for stars not found in Skycat from dynamic HDN catalog
	table=startable
	zero_ids=long(strmid(table[index].starid,3,6))
	get_cat,'HDN' ; load from dynamic HDN catalog
;
	hdn_ids=long(strmid(startable.starid,3,6))
	j=whereequal(zero_ids,hdn_ids)
	if j[0] ne -1 then count=n_elements(j) else count=0
	n=0L
	for i=0L,count-1 do begin
		jndex=where(hdn_ids eq zero_ids[j[i]],l)
		if l eq 1 then begin
			n=n+1
			t=table[index[j[i]]]
			struct_assign,startable[jndex],t
			table[index[j[i]]]=t
		endif
	endfor
	print,'Entries found in HDN.xdr: ',n
	index=where(strmid(table.starid,0,3) eq 'HDN' $
		       and table.hdn eq 0,count)
	if count gt 0 then begin
		print,'WARNING: unresolved HDN entries: ',count
		print,'Use hdn_startable,HD_ID to add star.'
	endif
	startable=table
endif
;
print,'Finished reading catalogs.'
;
end
