function read_jsdc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Get name of latest FITS file for JSDC, to be read by  get_jsdc
;
jsdc_fits=file_search(!oyster_dir+'starbase/JMMC/jsdc_????_??_??.fits')
if strlen(jsdc_fits[0]) eq 0 then begin
	print,'Error(GET_JSDC): FITS file not found!'
	return,-1
endif
; Use latest version
jsdc_fits=jsdc_fits[n_elements(jsdc_fits)-1]
;
d=mrdfits(jsdc_fits,1,header)
; We can only handle HD and HIP IDs, but must remove, e.g., TYC IDs
tags=tag_names(d)
index=where(strpos(tags,'MAINID_SIMBAD') ge 0)
index=index[0]
if index lt 0 then names=d.name else names=d.(index)
index=where(strmid(names,0,3) eq 'HIP' $
	 or strmid(names,0,2) eq 'HD',count)
d=d[index]
;
; Remove blanks and reformat star IDs to OYSTER format
d.name=strcompress(d.name,/remove_all)
index=where(strmid(d.name,0,3) eq 'HIP')
hip=long(strmid(d[index].name,3,max(strlen(d.name))-3))
d[index].name='HIP'+string(hip,format='(i6.6)')
index=where(strmid(d.name,0,2) eq 'HD')
hdn=long(strmid(d[index].name,2,max(strlen(d.name))-2))
d[index].name='HDN'+string(hdn,format='(i6.6)')
;
return,d
;
; Obsolete!
; Find as many HIP IDs as possible for HD IDs and rename
hip=cri(long(strmid(d[index].name,3,6)),'hdn-hic')
jndex=where(hip gt 0)
d[index[jndex]].name='HIP'+string(hip[jndex],format='(i6.6)')
; Find as many HD IDs as possible for HIP IDs and rename
hdn=cri(long(strmid(d[index].name,3,6)),'hic-hdn')
jndex=where(hdn gt 0)
d[index[jndex]].name='HDN'+string(hdn[jndex],format='(i6.6)')
;
return,d
;
end
