pro read_obslist,obslist
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
if n_elements(obslist) eq 0 then begin
	print,'***Error(READ_OBSLIST): file undefined!'
	return
endif
if strupcase(obslist) eq 'ASTROMETRY' then begin
	status=dc_read_free(!oyster_dir+'npoi/obslist.don',fkv,/col)
	get_startable,'FKV'+string(fkv,format='(i4.4)')
	index=where(startable.mv lt 4.0)
	startable=startable[index]
	return
endif
result=file_search(obslist,count=fcount)
if fcount eq 0 then begin
	print,'***Error(READ_OBSLIST): file not found!'
	return
endif
stars=''
status=dc_read_free(obslist,stars,/col,ignore=['!'])
get_startable,stars
;
end
