function readpacket,pdr
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read and return packet specified with packet directory record 'pdr'.
;
common PacketData,pd_all,var_num,packet
;
packet={header:pdr}
;
case pdr.type of
;		FILE_HEADER
'00000000'X:	begin
		packet={header:pdr, $
			body:{ $
			Date:'                                 ' $
			}}
		date=packet.body.date
		date_b=byte(date)
		status=linknload(!external_lib,'readfileheader', $
			pdr.file,pdr.offset,pdr.length, $
			date,date_b)
		packet.body.date=date
		packet.body.date=string(date_b)
		end
;		SYS_CONFIG
'000a0000'X:	begin
		numsid=0l
		numout=0l
		maxwav=0l
		maxbas=0l
		command=0l
		status=linknload(!external_lib,'readsysconfig', $
			pdr.file,pdr.offset,pdr.length, $
			command,numsid,numout,maxwav,maxbas)
		maxtriple=(numsid-1)*(numsid-2)/2
		maxconfig=numsid
		for i=2,numsid do maxconfig=maxconfig+combinations(numsid,i)
		packet={header:pdr, $
			body:{ $
			genconfig:allocGenConfig(numsid,numout,maxtriple,maxbas,maxwav,maxconfig), $
			geoparms:allocGeoParms(),systemid:'' $
			}}
		latitude=packet.body.geoparms.latitude
		longitude=packet.body.geoparms.longitude
		altitude=packet.body.geoparms.altitude
		earthradius=packet.body.geoparms.earthradius
		j2=packet.body.geoparms.j2
		tdtutc=packet.body.geoparms.tdt_tai
		ut1utc=0.d0
		instrcohint=packet.body.genconfig.instrcohint
		numbin=packet.body.genconfig.numbin
		beamcid=packet.body.genconfig.beamcombinerid
		stationcoord=packet.body.genconfig.stationcoord
		stationid=packet.body.genconfig.stationid & stationid[*]='123'
		stationid_b=byte(stationid)
		stroke=packet.body.genconfig.stroke
		fdltankid=packet.body.genconfig.delaylineid
		fringemod=packet.body.genconfig.fringemod
		biasmod=packet.body.genconfig.biasmod
		inputpair=lonarr(2,maxbas,numout)
		wavelength=packet.body.genconfig.wavelength
		wavelengtherr=packet.body.genconfig.wavelengtherr
		chanwidth=packet.body.genconfig.chanwidth
		chanwidtherr=packet.body.genconfig.chanwidtherr
		numbas=packet.body.genconfig.numbaseline
		numbias=packet.body.genconfig.numbiasfreq
		numwav=packet.body.genconfig.numspecchan
		command=1l
		status=linknload(!external_lib,'readsysconfig', $
			pdr.file,pdr.offset,pdr.length, $
			command,numsid,numout,maxwav,maxbas, $
			latitude,longitude,altitude,earthradius,j2, $
			tdtutc,ut1utc, $
			instrcohint,numbin,beamcid, $
			stationcoord,stationid,stationid_b,stroke,fdltankid, $
			fringemod,biasmod,inputpair, $
			wavelength,wavelengtherr,chanwidth,chanwidtherr, $
			numbas,numbias,numwav)
		packet.body.geoparms.latitude=latitude
		packet.body.geoparms.longitude=longitude
		packet.body.geoparms.altitude=altitude
		packet.body.geoparms.earthradius=earthradius
		packet.body.geoparms.j2=j2
		packet.body.geoparms.tai_utc=tdtutc
		packet.body.genconfig.numsid=numsid
		packet.body.genconfig.numoutbeam=numout
		packet.body.genconfig.numtriple=0
		packet.body.genconfig.numbaseline=numbas
		packet.body.genconfig.numbiasfreq=numbias
		packet.body.genconfig.numspecchan=numwav
		packet.body.genconfig.stationcoord=stationcoord
		packet.body.genconfig.delaylineid=fdltankid
		packet.body.genconfig.stationid=stationid
		packet.body.genconfig.fringemod=fringemod
		packet.body.genconfig.biasmod=biasmod
		packet.body.genconfig.wavelength=wavelength
		packet.body.genconfig.wavelengtherr=wavelengtherr
		packet.body.genconfig.chanwidth=chanwidth
		packet.body.genconfig.chanwidtherr=chanwidtherr
		packet.body.genconfig.numbaseline=numbas
		packet.body.genconfig.numspecchan=numwav
		packet.body.genconfig.baselineid=strjoin(stationid[inputpair],'-')
		packet.body.genconfig.refstation=1
		packet.body.systemid='NPOI'
		end
;		SCAN_START_VERSION_1
'000b0000'X:	begin
		packet={header:pdr, $
			body:{ $
			ScanId:0l,StarId:'                                 ' $
			}}
		scanid=packet.body.scanid
		starid=packet.body.starid
		starid_b=byte(starid)
		status=linknload(!external_lib,'readscanstartversion1', $
			pdr.file,pdr.offset,pdr.length, $
			scanid,starid,starid_b)
		packet.body.scanid=scanid
		packet.body.starid=starid
		end
;		FDL_POSITION
'000e0001'X:	begin
		packet={header:pdr, $
			body:{ $
			laserpath:dblarr(var_num.fdl,var_num.rec), $
			timestamp:lonarr(var_num.rec) $
			}}
		laserpath=packet.body.laserpath
		time=packet.body.timestamp
		status=linknload(!external_lib,'readfdlposition', $
			pdr.file,pdr.offset,pdr.length, $
			laserpath,time, $
			var_num.fdl,var_num.rec)
		packet.body.laserpath=laserpath
		packet.body.timestamp=time
		packet.header.time=time[var_num.rec-1]
		end
;		FRINGE_DATA_VERSION_1
'000c0001'X:	begin
		fcde=replicate({value:0,error:0},var_num.spec,var_num.rec)
		packet={header:pdr, $
			body:{ $
			bincounts:bytarr(var_num.spec,var_num.bin,var_num.chan,var_num.rec), $
			fcde:fcde $
			}}
		counts=packet.body.bincounts
		status=linknload(!external_lib,'readfringedataversion1', $
			pdr.file,pdr.offset,pdr.length, $
			counts, $
			var_num.spec,var_num.bin,var_num.chan,var_num.rec)
		packet.body.bincounts=counts
		end
;		FRINGE_BG
'000c0004'X:	begin
		packet={header:pdr, $
			body:{ $
			bincounts:bytarr(var_num.spec,var_num.bin,var_num.chan,var_num.rec), $
			timestamp:lonarr(var_num.rec) $
			}}
		counts=packet.body.bincounts
		time=packet.body.timestamp
		status=linknload(!external_lib,'readfringebg', $
			pdr.file,pdr.offset,pdr.length, $
			counts,time, $
			var_num.spec,var_num.bin,var_num.chan,var_num.rec)
		packet.body.bincounts=counts
		packet.body.timestamp=time
		packet.header.time=time[var_num.rec-1]
		end
;		NAT_COUNTS
'000d0001'X:	begin
		packet={header:pdr, $
			body:{ $
			quadcounts:intarr(var_num.sid,4,var_num.rec), $
			timestamp:lonarr(var_num.rec) $
			}}
		counts=packet.body.quadcounts
		time=packet.body.timestamp
		status=linknload(!external_lib,'readnatcounts', $
			pdr.file,pdr.offset,pdr.length, $
			counts,time, $
			var_num.sid,var_num.rec)
		packet.body.quadcounts=counts
		packet.body.timestamp=time
		packet.header.time=time[var_num.rec-1]
		end
;		FRINGE_DARK
'000c0005'X:	begin
		packet={header:pdr, $
			body:{ $
			rate:fltarr(var_num.spec,var_num.chan), $
			numint:0l,time:0l $
			}}
		rate=packet.body.rate
		time=packet.body.time
		status=linknload(!external_lib,'readfringedark', $
			pdr.file,pdr.offset,pdr.length, $
			rate,time, $
			var_num.spec,var_num.chan)
		packet.body.rate=rate
		packet.body.time=time
		end
	else:	if not !qiet then $
		print,'***Error(READPACKET): unknown packet type '+ $
			packettype(pdr.type)+'!'
endcase
;
return,packet
;
end
