pro readshell,modelfile,l,r,f
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read radial flux density profiles provided by various spherical shell
; radiative transfer simulations, such as DUSTY or Ralf's.
;
common ShellImage,l_shell,r_shell,f_shell
;
; Read and decode file, last # line before data must contain wavelengths
status=dc_read_fixed(modelfile,lines,/col,format='(a300)')
index=where(strpos(lines,'#') ge 0,count)
nr=n_elements(lines)-count              ; number of values of b
;
; Determine format: DUSTY, Ralf's raytrace, etc...
v=float(lines[count:count+nr-1])
if n_elements(unique(v)) lt nr/2 then begin
;	Ralf's...
	l_shell=unique(v)*1e-6
	nl=n_elements(l_shell)
	nr=nr/nl
	status=dc_read_free(modelfile,l,p,i,/col,ignore=['#'])
	r_shell=p[0:nr-1]/p[1]	; normalize to inner shell radius
	f_shell=transpose(reform(i,nr,nl))
endif else begin
       	words=nameparse(lines[index[count-1]])
       	nl=n_elements(words)-3                  ; do not count #,b,t(b)
       	l_shell=float(words[3:3+nl-1])
	nr=nr-1
       	f_shell=fltarr(nl,nr)
       	r_shell=fltarr(nr)
       	for i=0,nr-1 do begin
               	words=nameparse(lines[count+i])
               	r_shell[i]=float(words[0])
               	for j=0,nl-1 do f_shell[j,i]=float(words[2+j])
       	endfor
	l_shell=l_shell*1e-6
endelse
;
l=l_shell
;
; Some radii occur more than once
uindex=uniq(r_shell)
r=r_shell[uindex]
f=f_shell[*,uindex]
;
for i=0,n_elements(r)-1 do begin
	index=where(r_shell eq r[i],count)
	if count gt 1 then f[*,i]=total(f_shell[*,index],2)/count
endfor
;
end
