pro reduceobslist,r
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a startable, try to replace close pairings (within r [deg]) with
; brighter of the two stars, or the middle star for compact groups.
;
common StarBase,startable,notes
;
RAD=180/!pi
;
for radius=1,nint(r) do begin
;
repeat begin
	n=n_elements(startable)
	nstars=intarr(n)
	ra=startable.ra*15/RAD
	dec=startable.dec/RAD
	x=cos(dec)*sin(ra)
	y=cos(dec)*cos(ra)
	z=sin(dec)
	for i=0,n-1 do begin
		dist=sqrt((x-x[i])^2+(y-y[i])^2+(z-z[i])^2)
		index=where(dist lt radius/RAD,count)
		nstars[i]=count
	endfor
	i=where(nstars eq max(nstars))
	dist=sqrt((x-x[i[0]])^2+(y-y[i[0]])^2+(z-z[i[0]])^2)
	stars=startable[where(dist lt radius/RAD)]
	if max(nstars) eq 2 then index=where(stars.mv ne min(stars.mv),count) $
			    else index=where(stars.starid ne startable[i[0]].starid,count)
	if count gt 0 then removestar,stars[index].starid
endrep until count eq 0
;
endfor
;
end
