pro referencestation,station,class
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Change the reference station.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if checkdata([8]) ne 0 then return
;
if n_elements(class) eq 0 then class='all'
;
ibr=where(GenConfig.StationId eq station,count) & ibr=ibr[0]
if count eq 0 then begin
	print,'***Error(REFERENCESTATION): invalid station!'
	return
endif
obr=GenConfig.RefStation-1
GenConfig.RefStation=ibr+1
;
; Convert "pos" data to absolute
if (class eq 'scan' or class eq 'all') and n_elements(scans) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne obr then $
		scans[*].FDLPos(i)=scans[*].FDLPos(i)+scans[*].FDLPos(obr)
	endfor
endif
if (class eq 'point' or class eq 'all') and n_elements(Rec0) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne obr then begin
		FDLPos[i,*]=FDLPos[i,*]+FDLPos[obr,*]
		if n_elements(MetroPos) gt 0 then $
		MetroPos[i,*]=MetroPos[i,*]+MetroPos[obr,*]
		endif
	endfor
endif
if (class eq 'raw' or class eq 'all') and n_elements(Raw0) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne obr then begin
		LaserPos[i,*]=LaserPos[i,*]+LaserPos[obr,*]
		GeoPos[i,*]=GeoPos[i,*]+GeoPos[obr,*]
		endif
	endfor
endif
;
; Reference to new reference station
if (class eq 'scan' or class eq 'all') and n_elements(scans) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne ibr then begin
		scans[*].FDLPos(i)=scans[*].FDLPos(i)-scans[*].FDLPos(ibr)
		scans[*].GeoDelay(i)=scans[*].GeoDelay(i)-scans[*].GeoDelay(ibr)
		scans[*].GrpDelay(i)=scans[*].GrpDelay(i)-scans[*].GrpDelay(ibr)
		scans[*].DryDelay(i)=scans[*].DryDelay(i)-scans[*].DryDelay(ibr)
		scans[*].WetDelay(i)=scans[*].WetDelay(i)-scans[*].WetDelay(ibr)
		scans[*].MetroDelay(i)=scans[*].MetroDelay(i)-scans[*].MetroDelay(ibr)
		scans[*].WhiteDelay(i)=scans[*].WhiteDelay(i)-scans[*].WhiteDelay(ibr)
		endif
	endfor
	scans[*].GeoDelay(ibr)=0
	scans[*].GrpDelay(ibr)=0
	scans[*].DryDelay(ibr)=0
	scans[*].WetDelay(ibr)=0
	scans[*].MetroDelay(ibr)=0
	scans[*].WhiteDelay(ibr)=0
endif
if (class eq 'point' or class eq 'all') and n_elements(Rec0) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne ibr then begin
		FDLPos[i,*]=FDLPos[i,*]-FDLPos[ibr,*]
		if n_elements(MetroPos) gt 0 then $
		MetroPos[i,*]=MetroPos[i,*]-MetroPos[ibr,*]
		if n_elements(GrpDelay) gt 0 then begin
		GrpDelay[i,*]=GrpDelay[i,*]-GrpDelay[ibr,*]
		DryDelay[i,*]=DryDelay[i,*]-DryDelay[ibr,*]
		WetDelay[i,*]=WetDelay[i,*]-WetDelay[ibr,*]
		endif
		endif
	endfor
	if n_elements(GrpDelay) gt 0 then begin
		GrpDelay[ibr,*]=0
		DryDelay[ibr,*]=0
		WetDelay[ibr,*]=0
	endif
endif
if (class eq 'raw' or class eq 'all') and n_elements(Raw0) ne 0 then begin
	for i=0,GenConfig.NumSid-1 do begin
		if i ne ibr then begin
			LaserPos[i,*]=LaserPos[i,*]-LaserPos[ibr,*]
			GeoPos[i,*]=GeoPos[i,*]-GeoPos[ibr,*]
		endif
	endfor
endif
;
print,'Reference station set.'
;
end
