function refraction,hadec0,ft=ft,rh=rh,bp=bp,lambda=lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common LocalRefraction,ft0,fh0,bp0,lambda0
;
if n_elements(ft0) eq 0 then ft0=56.3
if n_elements(rh0) eq 0 then rh0=33.0
if n_elements(bp0) eq 0 then bp0=23.316
if n_elements(lambda0) eq 0 then lambda0=0.65
;
if n_elements(ft) eq 0 then ft=ft0
if n_elements(rh) eq 0 then rh=rh0
if n_elements(bp) eq 0 then bp=bp0
if n_elements(bp) eq 0 then bp=bp0
if n_elements(lambda) eq 0 then lambda=lambda0
;
RAD=180/!pi
;
azel=horizon2azel(equatorial2horizon(hadec2equatorial(hadec0)))
del=((oneill(lambda,ft,rh,bp)-1)/tan(azel[1,*]/RAD))*RAD
azel[1,*]=azel[1,*]+del
hadec=equatorial2hadec(horizon2equatorial(azel2horizon(azel)))
;
ft0=ft
rh0=rh
bp0=bp
;
return,hadec
;
end
