pro removestar,stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Remove one or more star from the startable.
;
common StarBase,startable,notes
;
if n_elements(stars) eq 0 then begin
	print,'***Error(REMOVESTAR): stars not defined!'
	return
endif else stars=strupcase(stars)
;
n1=n_elements(startable)
if n1 eq 0 then return
;
for i=0,n_elements(stars)-1 do begin
	index=where(startable.starid ne stars[i],count)
	if count gt 0 then startable=startable[index] else begin
		print,'***Error(REMOVESTAR): no stars would remain in table!'
		return
	endelse
endfor
;
n2=n_elements(startable)
n=n1-n2
if n eq 1 then print,'Removed 1 star.' $
	  else print,'Removed ',n,' stars.',format='(a,i2,a)'
;
end
