function remsteps,y,step
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Remove steps form a series of smoothly varying values. Once a discontinuity
; of 10 times the median change is detected, add or subtract the supplied step.
; Step must be positive
;
n=n_elements(y)
d=y[1:n-1]-y[0:n-2]
;
; Determine median step size
stepsize=abs(median(d))
;
index=where(abs(d) gt min([stepsize*10,step]),count)
;
for i=count-1,0 do begin
	y[0:index[i]]=y[0:index[i]]+(step*((d[index[i]] gt 0)*2-1))
endfor
;
return,y
;
end
