pro rename_bsc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Replace Flamsteed+Bayer IDs from the HR catalog in the star names with
; Greek letters if the Bayer ID is available, otherwise just keep the
; Flamsteed ID. Example: '4201 COM' -> 'ALP COM', '15   LYN' -> '15 LYN'
;
common StarBase,StarTable,Notes
;
greek_alphabet=['   ','ALP','BET','GAM','DEL','EPS','ZET','ETA','THE','IOT', $
		'KAP','LAM',' MU',' NU',' XI','OMI',' PI','RHO','SIG','TAU', $
		'UPS','PHI','CHI','PSI','OME']
;
index_bsc=where(strmid(StarTable.starid,0,3) eq 'BSC',count_bsc)
index_bsc=where(StarTable.bsc ne 0,count_bsc)
on_ioerror,skip
if count_bsc gt 0 then begin
	flamsteed=strmid(StarTable[index_bsc].name,0,3)
	bayer=strmid(StarTable[index_bsc].name,3,2)
	bayer_no=intarr(count_bsc)
	jndex=where(strlen(strcompress(bayer,/remove_all)) gt 0,count_bayer)
	if count_bayer gt 0 then bayer_no[jndex]=fix(bayer[jndex])
	number=strmid(StarTable[index_bsc].name,5,2)
	constellation=strmid(StarTable[index_bsc].name,7,3)
	index=where(bayer_no gt 0,count)
	if count gt 0 then flamsteed[index]=''
	name=flamsteed+' '+greek_alphabet[bayer_no]+number+' '+constellation
	name=strtrim(strcompress(name),2)
	if count_bsc eq 1 then StarTable[index_bsc].name=name[0] else $
	if count_bsc ne 0 then StarTable[index_bsc].name=name
endif
;
skip:
;
end
