pro rename_starids,request
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Rename stars to new catalogue system. If given a list of stars, rename
; starids in startable to match the names using existing ID numbers.
;
common StarBase,StarTable,Notes
;
starids=StarTable.starid
starids_bck=starids
;
; If request is an array, it is a list of stars to be homogenized
if n_elements(request) gt 1 then begin
   ustars=unique(request)
   ustids=unique(startable.starid)
;  FKV0000 is "alpha lab"
   index=where(ustars ne 'FKV0000',count)
   if count gt 0 then begin
      ustars=ustars[index]
      ustids=ustids[index]
      for i=0,n_elements(ustars)-1 do begin
         if ustars[i] ne ustids[i] then begin
	   case strmid(ustars[i],0,3) of
	   'FKV':StarTable[where(StarTable.fkv $
		   eq long(strmid(ustars[i],3,6)))].starid=ustars[i]
	   'BSC':StarTable[where(StarTable.bsc $
		   eq long(strmid(ustars[i],3,6)))].starid=ustars[i]
	   'HDN':StarTable[where(StarTable.hdn $
		   eq long(strmid(ustars[i],3,6)))].starid=ustars[i]
	   'HIP':StarTable[where(StarTable.hic $
		   eq long(strmid(ustars[i],3,6)))].starid=ustars[i]
	   else:
	   endcase
	endif
      endfor
   endif
   return
endif
;
if n_elements(request) eq 0 then begin
	print,"ERROR(RENAME_STARIDS): please specify request, e.g., 'fkv-bsc'"
	return
endif
;
if request eq 'hic-hip' then begin
	i=where(StarTable.hic ne 0,count)
	if count gt 0 then begin
		starids='HIP'+stringl(StarTable[i].hic,format='(i6.6)')
		StarTable[i].starid=starids
	endif
	return
endif
if request eq 'hip-hic' then begin
	i=where(StarTable.hic ne 0,count)
	if count gt 0 then begin
		starids='HIC'+stringl(StarTable[i].hic,format='(i6.6)')
		StarTable[i].starid=starids
	endif
	return
endif
if strpos(request,'hip-') ne -1 then begin
	strput,request,'hic-',0
endif
if strpos(request,'-hip') ne -1 then begin
	strput,request,'-hic',3
	do_hip=1
endif else do_hip=0
;
if strpos(request,'-hdn') ne -1 then begin
	i=where(StarTable.hdn ne 0,count)
	if count gt 0 then $
		starids[i]='HDN'+stringl(StarTable[i].hdn,format='(i6.6)')
endif
if strpos(request,'-bat') ne -1 then begin
	i=where(StarTable.bat ne 0,count)
	if count gt 0 then $
		starids[i]='BAT'+stringl(StarTable[i].bat,format='(i4.4)')
endif
if strpos(request,'-bsc') ne -1 then begin
	i=where(StarTable.bsc ne 0,count)
	if count gt 0 then $
		starids[i]='BSC'+stringl(StarTable[i].bsc,format='(i4.4)')
endif
if strpos(request,'-wds') ne -1 then begin
	i=where(StarTable.wds ne 0,count)
	if count gt 0 then $
		starids[i]='WDS'+stringl(StarTable[i].wds,format='(i10.9)')
endif
if strpos(request,'-sao') ne -1 then begin
	i=where(StarTable.sao ne 0,count)
	if count gt 0 then $
		starids[i]='SAO'+stringl(StarTable[i].sao,format='(i6.6)')
endif
if strpos(request,'-hic') ne -1 then begin
	i=where(StarTable.hic ne 0,count)
	if count gt 0 then $
		starids[i]='HIC'+stringl(StarTable[i].hic,format='(i6.6)')
endif
if strpos(request,'-fkv') ne -1 then begin
	i=where(StarTable.fkv ne 0,count)
	if count gt 0 then $
		starids[i]='FKV'+stringl(StarTable[i].fkv,format='(i4.4)')
endif
if strpos(request,'-fln') ne -1 then begin
	i=where(StarTable.fln ne 0,count)
	if count gt 0 then $
		starids[i]='FLN'+stringl(StarTable[i].fln,format='(i4.4)')
endif
;
case request of
	'fkv-hic':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
		  	hic_ids=cri(long(strmid(starids[i],3,4)),'fkv-hic')
		  	starids[i]='HIC'+stringl(hic_ids,format='(i6.6)')
			StarTable[i].hic=hic_ids
		  endif
		  i=where(StarTable.hic eq -1,count)
		  if count gt 0 then StarTable[i].hic=0
		  end
	'hic-fkv':begin
		  i=where(strmid(starids,0,3) eq 'HIC' or $
			  strmid(starids,0,3) eq 'HIP',count)
		  if count gt 0 then begin
		  	fkv_ids=cri(long(strmid(starids[i],3,6)),'hic-fkv')
		  	starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'fkv-bsc':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
			bsc_ids=cri(long(strmid(starids[i],3,4)),'fkv-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'bsc-fkv':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			fkv_ids=cri(long(strmid(starids[i],3,4)),'bsc-fkv')
			starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'fkv-sao':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
			sao_ids=cri(cri(long(strmid(starids[i],3,4)),'fkv-hdn'),'hdn-sao')
			starids[i]='SAO'+stringl(sao_ids,format='(i4.4)')
			StarTable[i].sao=sao_ids
		  endif
		  i=where(StarTable.sao eq -1,count)
		  if count gt 0 then StarTable[i].sao=0
		  end
	'sao-fkv':begin
		  i=where(strmid(starids,0,3) eq 'SAO',count)
		  if count gt 0 then begin
			fkv_ids=cri(cri(long(strmid(starids[i],3,6)),'sao-hdn'),'hdn-fkv')
			starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'fkv-hdn':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,4)),'fkv-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'hdn-fkv':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			fkv_ids=cri(long(strmid(starids[i],3,6)),'hdn-fkv')
			starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'bat-hdn':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,4)),'bat-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'hdn-bat':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			bat_ids=cri(long(strmid(starids[i],3,6)),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'fkv-bat':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,4)),'fkv-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'bat-fkv':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			fkv_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-fkv')
			starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'bat-bsc':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			bsc_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'hic-bsc':begin
		  i=where(strmid(starids,0,3) eq 'HIC' or $
			  strmid(starids,0,3) eq 'HIP',count)
		  if count gt 0 then begin
			bsc_ids=cri(cri(long(strmid(starids[i],3,6)),'hic-hdn'),'hdn-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'bsc-bat':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,4)),'bsc-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'bsc-hic':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			hic_ids=cri(cri(long(strmid(starids[i],3,4)),'bsc-hdn'),'hdn-hic')
			starids[i]='HIC'+stringl(hic_ids,format='(i6.6)')
			StarTable[i].hic=hic_ids
		  endif
		  i=where(StarTable.hic eq -1,count)
		  if count gt 0 then StarTable[i].hic=0
		  end
	'bat-hic':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			hic_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-hic')
			starids[i]='HIC'+stringl(hic_ids,format='(i6.6)')
			StarTable[i].hic=hic_ids
		  endif
		  i=where(StarTable.hic eq -1,count)
		  if count gt 0 then StarTable[i].hic=0
		  end
	'hic-bat':begin
		  i=where(strmid(starids,0,3) eq 'HIC' or $
			  strmid(starids,0,3) eq 'HIP',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,6)),'hic-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'bat-sao':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			sao_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-sao')
			starids[i]='SAO'+stringl(sao_ids,format='(i6.6)')
			StarTable[i].sao=sao_ids
		  endif
		  i=where(StarTable.sao eq -1,count)
		  if count gt 0 then StarTable[i].sao=0
		  end
	'sao-bat':begin
		  i=where(strmid(starids,0,3) eq 'SAO',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,6)),'sao-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'bat-fln':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			fln_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-fln')
			starids[i]='FLN'+stringl(fln_ids,format='(i4.4)')
			StarTable[i].fln=fln_ids
		  endif
		  i=where(StarTable.fln eq -1,count)
		  if count gt 0 then StarTable[i].fln=0
		  end
	'fln-bat':begin
		  i=where(strmid(starids,0,3) eq 'FLN',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,4)),'fln-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'fln-bsc':begin
		  i=where(strmid(starids,0,3) eq 'FLN',count)
		  if count gt 0 then begin
			bsc_ids=cri(cri(long(strmid(starids[i],3,4)),'fln-hdn'),'hdn-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'bsc-fln':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			fln_ids=cri(cri(long(strmid(starids[i],3,4)),'bsc-hdn'),'hdn-fln')
			starids[i]='FLN'+stringl(fln_ids,format='(i4.4)')
			StarTable[i].fln=fln_ids
		  endif
		  i=where(StarTable.fln eq -1,count)
		  if count gt 0 then StarTable[i].fln=0
		  end
	'fln-hdn':begin
		  i=where(strmid(starids,0,3) eq 'FLN',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,4)),'fln-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i4.4)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'hdn-fln':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			fln_ids=cri(long(strmid(starids[i],3,4)),'hdn-fln')
			starids[i]='FLN'+stringl(fln_ids,format='(i4.4)')
			StarTable[i].fln=fln_ids
		  endif
		  i=where(StarTable.fln eq -1,count)
		  if count gt 0 then StarTable[i].fln=0
		  end
	'bat-wds':begin
		  i=where(strmid(starids,0,3) eq 'BAT',count)
		  if count gt 0 then begin
			wds_ids=cri(cri(long(strmid(starids[i],3,4)),'bat-hdn'),'hdn-wds')
			starids[i]='WDS'+stringl(wds_ids,format='(i10.9)')
			StarTable[i].wds=wds_ids
		  endif
		  i=where(StarTable.wds eq -1,count)
		  if count gt 0 then StarTable[i].wds=0
		  end
	'wds-bat':begin
		  i=where(strmid(starids,0,3) eq 'WDS',count)
		  if count gt 0 then begin
			bat_ids=cri(cri(long(strmid(starids[i],3,10)),'wds-hdn'),'hdn-bat')
			starids[i]='BAT'+stringl(bat_ids,format='(i4.4)')
			StarTable[i].bat=bat_ids
		  endif
		  i=where(StarTable.bat eq -1,count)
		  if count gt 0 then StarTable[i].bat=0
		  end
	'wds-bsc':begin
		  i=where(strmid(starids,0,3) eq 'WDS',count)
		  if count gt 0 then begin
			bsc_ids=cri(long(strmid(starids[i],3,10)),'wds-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'bsc-wds':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			wds_ids=cri(long(strmid(starids[i],3,4)),'bsc-wds')
			starids[i]='WDS'+stringl(wds_ids,format='(i10.9)')
			StarTable[i].wds=wds_ids
		  endif
		  i=where(StarTable.wds eq -1,count)
		  if count gt 0 then StarTable[i].wds=0
		  end
	'fkv-wds':begin
		  i=where(strmid(starids,0,3) eq 'FKV',count)
		  if count gt 0 then begin
			wds_ids=cri(cri(long(strmid(starids[i],3,4)),'fkv-hdn'),'hdn-wds')
			starids[i]='WDS'+stringl(wds_ids,format='(i10.9)')
			StarTable[i].wds=wds_ids
		  endif
		  i=where(StarTable.wds eq -1,count)
		  if count gt 0 then StarTable[i].wds=0
		  end
	'wds-fkv':begin
		  i=where(strmid(starids,0,3) eq 'WDS',count)
		  if count gt 0 then begin
			fkv_ids=cri(cri(long(strmid(starids[i],3,10)),'wds-hdn'),'hdn-fkv')
			starids[i]='FKV'+stringl(fkv_ids,format='(i4.4)')
			StarTable[i].fkv=fkv_ids
		  endif
		  i=where(StarTable.fkv eq -1,count)
		  if count gt 0 then StarTable[i].fkv=0
		  end
	'bsc-hdn':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,4)),'bsc-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'bsc-sao':begin
		  i=where(strmid(starids,0,3) eq 'BSC',count)
		  if count gt 0 then begin
			sao_ids=cri(cri(long(strmid(starids[i],3,4)),'bsc-hdn'),'hdn-sao')
			starids[i]='SAO'+stringl(sao_ids,format='(i6.6)')
			StarTable[i].sao=sao_ids
		  endif
		  i=where(StarTable.sao eq -1,count)
		  if count gt 0 then StarTable[i].sao=0
		  end
	'sao-bsc':begin
		  i=where(strmid(starids,0,3) eq 'SAO',count)
		  if count gt 0 then begin
			bsc_ids=cri(cri(long(strmid(starids[i],3,6)),'sao-hdn'),'hdn-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'hdn-bsc':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			bsc_ids=cri(long(strmid(starids[i],3,6)),'hdn-bsc')
			starids[i]='BSC'+stringl(bsc_ids,format='(i4.4)')
			StarTable[i].bsc=bsc_ids
		  endif
		  i=where(StarTable.bsc eq -1,count)
		  if count gt 0 then StarTable[i].bsc=0
		  end
	'hdn-hic':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			hic_ids=cri(long(strmid(starids[i],3,6)),'hdn-hic')
			starids[i]='HIC'+stringl(hic_ids,format='(i6.6)')
			StarTable[i].hic=hic_ids
		  endif
		  i=where(StarTable.hic eq -1,count)
		  if count gt 0 then StarTable[i].hic=0
		  end
	'hic-hdn':begin
		  i=where(strmid(starids,0,3) eq 'HIC' or $
			  strmid(starids,0,3) eq 'HIP',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,6)),'hic-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
	    	  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'hdn-sao':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			sao_ids=cri(long(strmid(starids[i],3,6)),'hdn-sao')
			starids[i]='SAO'+stringl(sao_ids,format='(i6.6)')
			StarTable[i].sao=sao_ids
		  endif
		  i=where(StarTable.sao eq -1,count)
		  if count gt 0 then StarTable[i].sao=0
		  end
	'sao-hdn':begin
		  i=where(strmid(starids,0,3) eq 'SAO',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(strmid(starids[i],3,6)),'hdn-sao')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'wds-sao':begin
		  i=where(strmid(starids,0,3) eq 'WDS',count)
		  if count gt 0 then begin
			sao_ids=cri(long(strmid(starids[i],3,10)),'wds-sao')
			starids[i]='SAO'+stringl(sao_ids,format='(i6.6)')
			StarTable[i].sao=sao_ids
		  endif
		  i=where(StarTable.sao eq -1,count)
		  if count gt 0 then StarTable[i].sao=0
		  end
	'sao-wds':begin
		  i=where(strmid(starids,0,3) eq 'SAO',count)
		  if count gt 0 then begin
			wds_ids=cri(long(strmid(starids[i],3,6)),'sao-wds')
			starids[i]='WDS'+stringl(wds_ids,format='(i10.9)')
			StarTable[i].wds=wds_ids
		  endif
		  i=where(StarTable.wds eq -1,count)
		  if count gt 0 then StarTable[i].wds=0
		  end
	'wds-hdn':begin
		  i=where(strmid(starids,0,3) eq 'WDS',count)
		  if count gt 0 then begin
			hdn_ids=cri(long(wdsid(id2=starids[i])),'wds-hdn')
			starids[i]='HDN'+stringl(hdn_ids,format='(i6.6)')
			StarTable[i].hdn=hdn_ids
		  endif
		  i=where(StarTable.hdn eq -1,count)
		  if count gt 0 then StarTable[i].hdn=0
		  end
	'hdn-wds':begin
		  i=where(strmid(starids,0,3) eq 'HDN',count)
		  if count gt 0 then begin
			wds_ids=cri(long(strmid(starids[i],3,6)),'hdn-wds')
			starids[i]='WDS'+stringl(wds_ids,format='(i10.9)')
			StarTable[i].wds=wds_ids
		  endif
		  i=where(StarTable.wds eq -1,count)
		  if count gt 0 then StarTable[i].wds=0
		  end
             else:begin
		  print,'***Error(RENAME_STARIDS): request not valid!'
		  return
		  end
endcase
;
index=where(strmid(starids,3,4) eq '****' $
	or strmid(starids,3,10) eq '-000000001' ,count)
if count gt 0 then begin
	starids[index]=starids_bck[index]
	print,'Unresolved requests of type ',request,':',count,'.', $
		format='(a,a,a,i6,a)'
endif
;
if strpos(request,'-wds') ne -1 then begin
	index=where(strmid(starids,0,3) eq 'WDS',count)
	if count gt 0 then begin
		sign=strmid(starids[index],3,1)
		i=where(sign eq ' ',count)
		if count gt 0 then sign[i]='+'
		starids[index]='WDS'+sign+strmid(starids[index],4,9)
	endif
endif
if do_hip then begin
	index=where(strmid(starids,0,3) eq 'HIC',count)
	if count gt 0 then $
		starids[index]='HIP'+stringl(StarTable[index].hic,format='(i6.6)')
endif
;
StarTable.starid=starids
;
end
