pro replacebg,s
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Replace flagged background rates in a given background scan with
; average of other scans in same channel. Beware of white light scans
; which are not recognized by this procedure!
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; If bg scan was created, warn only of missing channels
index=where(s[0].RateErr eq 0,count)
if count gt 0 then expand=1 else expand=0
;
for i=0,GenConfig.NumOutBeam-1 do begin
channels=0
dead_channel_index=total(reform(bgscans.rateerr[i,*] > 0),2)
;
for j=0,GenConfig.NumSpecChan[i]-1 do begin
;
if s[0].RateErr(i,j) le 0 then begin
	index=where(bgscans[*].RateErr(i,j) gt 0,count)
	if count gt 0 then begin
		s[0].Time=abs(s[0].Time)
		if count gt 1 then begin
			s[0].Rate(i,j)=avg(bgscans[index].Rate(i,j))
			s[0].RateErr(i,j)=stddev(bgscans[index].Rate(i,j))
;			The standard deviation is zero after running medianbg
			if s[0].RateErr(i,j) eq 0 then $
			s[0].RateErr(i,j)=avg(bgscans[index].RateErr(i,j))
		endif else begin
			s[0].Rate(i,j)=bgscans[index].Rate(i,j)
			s[0].RateErr(i,j)=sqrt(s[0].Rate(i,j))
		endelse
		channels=[channels,j+1]
	endif else begin
		if expand and dead_channel_index[j] ne 0 then $
		print,'Warning(REPLACEBG): no data found for beam ', $
			i+1,', channel ',j+1,'!',format='(a,i1,a,i2,a)'
	endelse
endif
;
endfor
if n_elements(channels) gt 1 and not expand then $
print,'Replaced value for BGScan ',hms(s[0].time/3600.0),', beam ',i+1, $
		', channels ',retroparse(channels[1:n_elements(channels)-1]), $
		format='(a,a,a,i1,a,a)'
endfor
;
end
