pro resetcal,variable
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Completely removes calibration from data and re-creates cal_entries for
; selected data type.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(cal_options) eq 0 then initcal
if n_elements(variable) eq 0 then variable=cal_options.v
if variable eq 1 then begin
	scans.TripleAmpC=scans.TripleAmp
	scans.TripleAmpCErr=scans.TripleAmpErr
	scans.TripleAmpEC=scans.TripleAmpE
	scans.TripleAmpECErr=scans.TripleAmpEErr
endif else if variable eq 2 then begin
	scans.TriplePhaseC=scans.TriplePhase
	scans.TriplePhaseCErr=scans.TriplePhaseErr
endif else begin
	scans.VisSqC=scans.VisSq
	scans.VisSqCErr=scans.VisSqErr
	scans.VisSqEC=scans.VisSqE
	scans.VisSqECErr=scans.VisSqEErr
endelse
;
index=where(cal_entries.variable ne variable,count)
if count gt 0 then set_calentries,cal_entries[index] else create_calentries
;
print,'Calibration reset for data type ',cal_options.n[variable],'.', $
	format='(a,a,a)'
;
end
