pro resetflag,class
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(class) eq 0 then begin
	print,"***Error(RESETFLAG): you have to specify class!"
	return
endif
;
case class of
	'scan' :begin
		if checkdata([9]) ne 0 then return
		scans.time=abs(scans.time)
		scans.vissqerr=abs(scans.vissqerr)
		scans.vissqeerr=abs(scans.vissqeerr)
		scans.vissqcerr=abs(scans.vissqcerr)
		scans.vissqecerr=abs(scans.vissqecerr)
		scans.compltripleerr=abs(scans.compltripleerr)
		scans.tripleamperr=abs(scans.tripleamperr)
		scans.tripleampeerr=abs(scans.tripleampeerr)
		scans.tripleampcerr=abs(scans.tripleampcerr)
		scans.tripleampecerr=abs(scans.tripleampecerr)
		scans.triplephaseerr=abs(scans.triplephaseerr)
		scans.triplephasecerr=abs(scans.triplephasecerr)
		scans.photonrateerr=abs(scans.photonrateerr)
		scans.backgnderr=abs(scans.backgnderr)
		scans.fdlposerr=abs(scans.fdlposerr)
		scans.natjittererr=abs(scans.natjittererr)
		scans.delayjittererr=abs(scans.delayjittererr)
		scans.grpdelayerr=abs(scans.grpdelayerr)
		scans.drydelayerr=abs(scans.drydelayerr)
		scans.wetdelayerr=abs(scans.wetdelayerr)
		if n_elements(bufferinfo) gt 1 then $
		storenight,11
		end
	'bg'   :begin
		if checkdata([10]) ne 0 then return
		bgscans.time=abs(bgscans.time)
		bgscans.rateerr=abs(bgscans.rateerr)
		end
	'point':begin
		if checkdata([11]) ne 0 then return
		pointtime=abs(pointtime)
		vissqerr=abs(vissqerr)
		photonrateerr=abs(photonrateerr)
		if n_elements(compltriple) ne 0 then begin
			compltripleerr=abs(compltripleerr)
			tripleamperr=abs(tripleamperr)
			triplephaseerr=abs(triplephaseerr)
		endif
		fdlposerr=abs(fdlposerr)
		natjittererr=abs(natjittererr)
		delayjittererr=abs(delayjittererr)
		if n_elements(grpdelay) ne 0 then begin
			grpdelayerr=abs(grpdelayerr)
			drydelayerr=abs(drydelayerr)
			wetdelayerr=abs(wetdelayerr)
		endif
		end
	'metro':begin
		if checkdata([16]) ne 0 then return
		metrotime=abs(metrotime)
		parxerr=abs(parxerr)
		paryerr=abs(paryerr)
		parzerr=abs(parzerr)
		totaldelayerr=abs(totaldelayerr)
		end
	else:	print,'***Error(RESETFLAG): unknown class:',class,'!'
endcase
;
print,'Flags reset.'
;
end
