function response,l,t,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return response for wavelengths lambda given a bandpass defined by l and t
;
n=n_elements(l)
num=n_elements(lambda)
tm=fltarr(num)
;
if max(lambda) lt min(l) then return,lambda*0
if min(lambda) gt max(l) then return,lambda*0
;
for i=0,num-1 do begin
	d=abs(lambda[i]-l)
	j=where(d eq min(d)) & j=j[0]
	if lambda[i] le l[j] then begin
		if j eq 0 then tm[i]=t[0] else $
			       tm[i]=t[j-1] $
			+((lambda[i]-l[j-1])/(l[j]-l[j-1]))*(t[j]-t[j-1])
	endif else begin
		if j eq n-1 then tm[i]=t[n-1] else $
				 tm[i]=t[j] $
			+((lambda[i]-l[j])/(l[j+1]-l[j]))*(t[j+1]-t[j])
	endelse
endfor
;
return,tm
;
end
