pro rewraptriple,angle
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Used to effectively unwrap the triple phase by rotating the complex triple,
; recomputing the phase, and subtracting the rotation angle. The angle is
; chosen so that after rotation, the entire range of phases will fit into
; the interval [-180,+180].
;
; Only the triple phase of the selected calibrator stars is unwrapped!
;
; Note: unwraps all triples!
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(cal_stars) eq 0 then begin
	print,'***Error(REWRAPTRIPLE): no calibrator stars defined!'
	return
endif
if cal_stars[0] eq '' then begin
	print,'***Error(REWRAPTRIPLE): no calibrator stars selected!'
	return
endif
;
if n_elements(angle) eq 0 then begin
	read,'Please enter rotation angle [degrees]: ',angle
endif
angle=angle/rad
;
; Obtain scan index corresponding to calibrator selection
list_stars,stars
mask=intarr(n_elements(scans))
for k=0,n_elements(stars)-1 do begin
	index=where(cal_stars eq stars[k],count)
	if count eq 0 then begin
		index=where(scans.StarId eq stars[k])
		mask[index]=-1
	endif
endfor
calscan_index=where(mask eq 0,calscan_count)
;
numchan=n_elements(scans[0].triplephase(0,*))
numtrpl=n_elements(scans[0].triplephase(*,0))
;
real=scans[calscan_index].compltriple(*,0,*)
imag=scans[calscan_index].compltriple(*,1,*)
real_rot=real*cos(angle)-imag*sin(angle)
imag_rot=real*sin(angle)+imag*cos(angle)
index=where(real_rot eq 0 and imag_rot eq 0,count)
if count gt 0 then real_rot[index]=1
phas_rot=atan(imag_rot,real_rot)
scans[calscan_index].triplephasec=reform(phas_rot-angle,numtrpl,numchan,calscan_
;
if not !quiet then print,'Unwrapping completed.'
;
end
