pro rochelobes
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a binary model, compute the Roche lobe radii in mas.
; Modern Astrophyics, Carroll and Ostlie, p.687
; https://en.wikipedia.org/wiki/Roche_lobe
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
; print,'Roche lobe radii in solar radii:'
; a=((binary_model(0).period/365.25)^2*total(star_model.mass))^(1./3)
;
print,'Roche lobe radii in mas:'
a=binary_model[0].semimajoraxis
;
l1=a*(0.5-0.227*alog10(star_model[1].mass/star_model[0].mass))
l2=a*(0.5+0.227*alog10(star_model[1].mass/star_model[0].mass))
;
; Wikipedia
l1=a*(0.38+0.2*alog10(star_model[0].mass/star_model[1].mass))
l2=a*(0.38+0.2*alog10(star_model[1].mass/star_model[0].mass))
;
print,'Star 1:',l1
print,'Star 2:',l2
;
end
