function rocher,q
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return Roche lobe radius based on Eggleton, ApJ, 268, 368
; https://en.wikipedia.org/wiki/Roche_lobe
;
q23rd=q^(2./3)
q13rd=q^(1./3)
return,0.49*q23rd/(0.6*q23rd+alog(1.+q13rd))
;
end
